
def send_to_octave(solver,interactive=True,rmtemp=False,append=""):
    tempname = solver.model.fname + ".mod"
    f = file(tempname,'w')
    modtext = solver.export_to_modfile(options={},append=append)
    f.write(modtext)
    f.close()
    main_file = "%% main file for model : %s\n\n" % (solver.model.fname)
    main_file += 'addpath("%s")\n' % ("/home/pablo/Sources/dynare_4_svn/matlab")
    main_file += 'dynare("%s")\n' % (solver.model.fname)
    main_file += 'save -v6 %s M_ oo_ options_' % (solver.model.fname + "_res.mat")   
    
    g = file( solver.model.fname + "_main.m",'w')
    g.write(main_file)
    g.close()

    if interactive:
        import os
        command = 'gnome-terminal -e "octave --persist --eval \\"%s\\""' % ( solver.model.fname + "_main.m" )
        os.system( command)
        return None
    else:
        import os
        import scipy
        command = 'octave --eval "%s"' % ( solver.model.fname + "_main.m" )
        os.system(command)
        res = scipy.io.loadmat( solver.model.fname + "_res.mat")
        return res
    
def retrieve_results(mlab):
    d_M = dict()
    d_oo = dict()
    d_options = dict()
  
    
    m_options = mlab._get('options_')
    m_names = mlab.fieldnames(m_options)
    for m_name in m_names:
        #print(m_name)
        name = str(mlab.cell2mat(m_name))
        print(name)
        #name = m_name._[0]
        #print(name)
        #d_options[name] = getattr(m_options,name)#m_options.__getattr__(m_name)
    
    return(d_options)