from daredare import *

set_variables("x y")
set_exovariables("")
set_shocks("epsilon")
set_parameters("beta rho")

equations = [
    Equation( x(+1)**2 , 1 - beta + beta * x**2 ,'"Euler" equation'),
    Equation( x + y , 1 - rho + rho*(x(-1) + y(-1)) + epsilon)
]
preview(equations[0],output="pdf")

parameters_values = { beta: 1.1, rho: 0.9}

init_values = {x:1, y:0.1}

covariances = matrix([[0.1]])


model = Model("many_solutions",lookup=True)
model.check_all(print_info=True,print_eq_info=True)

solver = Solver(model,parameters_values,init_values,covariances)
print(solver.export_to_modfile({}))

# Try to solve the model using Uhligs toolkit

umodel = model.to_uhlig_model()
umodel.check_all(print_info=True,print_eq_info=True)

usolver = Solver(umodel,parameters_values,init_values,covariances)
ss = usolver.find_steady_state()


res = usolver.solve_with_uhligs_toolkit(print_matrices=False)

print('PP',res.PP)
print('QQ',res.QQ)
#from misc.matlab import *
#from mlabwrap import mlab
#send_to_dynare(solver, mlab)


#pf_model = model.process_portfolio_model()


#print(usolver.export_to_modfile())
