from daredare import *
#from misc import cal

set_variables("k c z")
set_exovariables("")
set_shocks("epsilon")
set_parameters("alpha beta gamma delta aa")

equations = [
    Equation(c + k , (1 - delta)*k(-1) + k(-1)**alpha*(1 + z)*aa,'First equation'),
    Equation(0 , -1/(1 + beta)*c(1)**(-gamma)*(1 - delta + k**(-1 + alpha)*(1 + z(1))*aa*alpha) + c**(-gamma)),
    Equation(z , epsilon)
]

preview(equations[0])

parameters_values = {
    alpha : 0.5,
    gamma : 0.5,
    delta : 0.02,
    beta : 0.05,
    aa : 0.5
}

covariances = matrix([[0.01]])

init_values = {
    k:(1/aa/alpha*(beta + delta))**(1/(-1 + alpha)),
    c:k**alpha*aa - delta*k
}

############################


model = Model("pyramst",lookup=True)
model.check_all()
model.check_type("dynare")

from misc.octave import send_to_octave

solver = Solver(model,lookup=True,covariances=covariances)

#res = solver.find_steady_state(return_dict=True)
#print solver.export_to_modfile(append="stoch_simul(nograph);")


res = send_to_octave(solver,interactive=False,append="steady;\ncheck;\nstoch_simul(nograph);")
print(res)
M = res['M_']
oo = res['oo_']
options = res['options_']

#text = solver.export_to_modfile()
#f = file("hello.mod",'w')
#f.write(text)
#f.close