from daredare import *
#from misc import cal

set_variables("k c z")
set_exovariables("")
set_shocks("epsilon")
set_parameters("alpha beta gamma delta aa")

equations = [
    Equation(c + k , (1 - delta)*k(-1) + k(-1)**alpha*(1 + z)*aa),
    Equation(0 , -1/(1 + beta)*c(1)**(-gamma)*(1 - delta + k**(-1 + alpha)*(1 + z(1))*aa*alpha) + c**(-gamma)),
    Equation(z , epsilon)
]

parameters_values = {
    alpha : 0.5,
    gamma : 0.5,
    delta : 2 * alpha,
    beta : 0.05,
    aa : 0.5
}

covariances = matrix([[0.01]])

init_values = {
    k:(1/aa/alpha*(beta + delta))**(1/(-1 + alpha)),
    c:k**alpha*aa - delta*k
}

############################


model = Model("pyramst",lookup=True)
model.check_all()
model.check_type("dynare")

xmlmodel = model.toxml()

solver = Solver(model,lookup=True)
xmlsolver = solver.toxmlmodfile()
filename = model.fname + ".xml"
f = file(filename,'w')
f.write(xmlsolver)
f.close()
os.system("tidy -xml -i -m " + filename)
