!**********************************************************************************
!
!	SUBROUTINE: StapoUpdate
!
!	PURPOSE: Updates Stapo to policy function achieved by previous convergence
!                 of the policy function iteration routine (i.e., for a lower
!                 value of kappa).
!			 
!	AUTHOR:	 Ben Malin 
!
!	DATE:    6/2004
!       REVISED: 6/2007
!
!**********************************************************************************

subroutine StapoUpdate
  
  ! inputs:
  !
  ! output:
  ! 
  ! remarks:
  !
  
  use Params
  
  implicit none
  
  !Variable Declaration
  integer :: j,i,i1,h,h1

  !At the origin
  do j = 1,N
     stapo0(j) = yCons0(j)
     stapo0(j+N) = yCap0(j)
  enddo
  
  !At points2
  do i = 1,d-1
     do i1 = i+1,d
        do h = 1, 2		!That is, h = 1, 2**(q-d-1)  where q-d = 2
           do h1 = 1, 2		!Same comment applies
              do j=1,N
                 stapo2(i,i1,h,h1,j) = yCons2(i,i1,h,h1,j)
                 stapo2(i,i1,h,h1,j+N) = yCap2(i,i1,h,h1,j)
              enddo
           enddo
        enddo
     enddo
  enddo
  
  !At points3
  do i = 1,d
     do h = 1, 4	!That is, h = 1, 2**(q-d)  where q-d = 2
        do j = 1,N
           stapo3(i,h,j) = yCons3(i,h,j)
           stapo3(i,h,j+N) = yCap3(i,h,j)
        enddo
     enddo
  enddo
  
end subroutine StapoUpdate
