!***********************************************************************************
!	MODULE:	InitGuess
!
!	PURPOSE: Contains subroutine InitCap
!
!	AUTHOR:	Ben Malin
!
!	DATE:	7/19/2007
!       REVISED: 
!
!***********************************************************************************

module InitGuess
  
  use Params

  implicit none
  
contains
  
  !***********************************************************************************
  !
  !	SUBROUTINE:  InitCap
  !
  !	PURPOSE: Specifies equation whose solution is the initial guess for
  !               country 1's future capital stock.
  !
  !	AUTHOR:	 Ben Malin 
  !
  !	DATE:    7/19/2007
  !     REVISED: 
  !
  !***********************************************************************************

  subroutine InitCap(pol,ICap,count)
    
    ! inputs:
    !    pol -- Holds guess of nonlinear equation solver
    !    count -- size of pol vector -- 1
    !
    ! output:
    !    ICap -- Values of equation evaluated at pol.
    ! 
    ! remarks:
    !    Pol(1) is tomorrow's (log) capital stock for country 1.
    !
    
    use Params

    implicit none
        
    !Variable Declaration
    integer,intent(in) :: count	
    real(prec),dimension(count),intent(in) :: pol	
    real(prec),dimension(count),intent(out) :: ICap
    
    real(prec) :: capital
    integer :: i

    !Transform guess from log(k) to k
    capital = exp(pol(1))

    !Construct equation
    ICap = 0.0
    do i = 1,N
       ICap = ICap + (exp(rho*muh/(1.0-muh)*(initz(1) - initz(i))) * (alpha/(1.0-alpha) &
            & + capital**(-muh)) - alpha/(1.0-alpha))**(-1.0/muh)
    end do
    ICap = ICap - aggK

  end subroutine InitCap

end module InitGuess
