% Main file to generate intial guess for solution to model A4
% Approximation is done in levels (k) and logs (a)

clear all

cpu0=cputime;

global N beta alpha delta sigma rho phi A gamma tau psi Le chi b mupar
global kmin kmax amin amax cmin cmax
global xgrid
global k1_mat k2_mat k3_mat k4_mat k5_mat k6_mat K_mat
global a1_mat a2_mat a3_mat a4_mat a5_mat a6_mat
global ap1_mat ap2_mat ap3_mat ap4_mat ap5_mat ap6_mat
global y1_mat y2_mat y3_mat y4_mat y5_mat y6_mat Y_mat
global regvec_labor1 regvec_labor2 regvec_labor3 regvec_labor4 regvec_labor5 regvec_labor6 mumin mumax

%%%%%%%%%%%%%%%%%%%%%%
% 1. Getting started %
%%%%%%%%%%%%%%%%%%%%%%

approx=1;   % set order of approximation for perturbation solution (initilization)

% 1) Calibration
N=6;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);

% gammalow=0.2;
% gammahigh=0.4;
% gamma=[gammalow:(gammahigh-gammalow)/(N-1):gammahigh];
gamma=ones(1,N)*0.25;

% chilow=0.75;
% chihigh=0.9;
% chi=[chilow:(chihigh-chilow)/(N-1):chihigh];
chi=ones(1,N)*0.83;

% muparlow=-0.3;
% muparhigh=0.3;
% mupar=[muparlow:(muparhigh-muparlow)/(N-1):muparhigh];
mupar=ones(1,N)*-0.2;

Le=2.5;


% 2) Compute the steady state, labor weights and Negishi weights

% a)
kss=1;
lss=1;
Kss=N*kss;
Lss=N*lss;
css=A*kss^alpha*lss^(1-alpha);
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=N*A;

% b) Compute labor weights
b=zeros(1,N);
for j=1:N
    b(j)=(1-alpha)*A^(1-1/chi(j))/[(Le-lss)^(-1/chi(j))];
end

% c) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=[css^(-1/chi(j))*[css^(1-1/chi(j))+b(j)*(Le-lss)^(1-1/chi(j))]^[(1-1/gamma(j))/(1-1/chi(j))-1]]^(-1);
end
muss=1;


% 3) Compute the steady state in logs
lnkss=log(kss);
lnKss=log(Kss);
lncss=log(css);
lnCss=log(Css);
lnthetass=log(thetass);
lnYss=log(Yss);
lnLss=log(Lss);
lnlss=log(lss);
lnmuss=log(muss);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. Construct first-order approximation using method by Klein (2000)  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Define symbolic variables
syms c1 lna1 k1 theta1 cp1 lnap1 kp1 thetap1 l1 lp1
syms c2 lna2 k2 theta2 cp2 lnap2 kp2 thetap2 l2 lp2
syms c3 lna3 k3 theta3 cp3 lnap3 kp3 thetap3 l3 lp3
syms c4 lna4 k4 theta4 cp4 lnap4 kp4 thetap4 l4 lp4
syms c5 lna5 k5 theta5 cp5 lnap5 kp5 thetap5 l5 lp5
syms c6 lna6 k6 theta6 cp6 lnap6 kp6 thetap6 l6 lp6 
syms C Cp K Kp Y Yp CAC CACp mu mup L Lp

syms lnc1 lna1 lnk1 lntheta1 lncp1 lnap1 lnkp1 lnthetap1 lnl1 lnlp1
syms lnc2 lna2 lnk2 lntheta2 lncp2 lnap2 lnkp2 lnthetap2 lnl2 lnlp2
syms lnc3 lna3 lnk3 lntheta3 lncp3 lnap3 lnkp3 lnthetap3 lnl3 lnlp3
syms lnc4 lna4 lnk4 lntheta4 lncp4 lnap4 lnkp4 lnthetap4 lnl4 lnlp4
syms lnc5 lna5 lnk5 lntheta5 lncp5 lnap5 lnkp5 lnthetap5 lnl5 lnlp5 
syms lnc6 lna6 lnk6 lntheta6 lncp6 lnap6 lnkp6 lnthetap6 lnl6 lnlp6
syms lnC lnCp lnK lnKp lnY lnYp CAC CACp lnmu lnmup lnL lnLp

% 2) Construct the system of equilibrium conditions

f1=exp(lnmu)*[1+phi*(exp(lnkp1)/exp(lnk1)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap1)+exp(lnap1)*alpha*A*...
    exp(lnkp1)^(mupar(1)-1)*[alpha*exp(lnkp1)^(mupar(1))+(1-alpha)*exp(lnlp1)^(mupar(1))]^(1/mupar(1)-1)];
f1b=b(1)*exp(lnc1)^(1/chi(1))*(Le-exp(lnl1))^(-1/chi(1))-...
    exp(lna1)*(1-alpha)*A*exp(lnl1)^(mupar(1)-1)*[alpha*exp(lnk1)^(mupar(1))+(1-alpha)*exp(lnl1)^(mupar(1))]^(1/mupar(1)-1);
f2=exp(lntheta1)-[1+phi*[1+0.5*(exp(lnkp1)/exp(lnk1)-1)]*(exp(lnkp1)/exp(lnk1)-1)];
f3=tau(1)*[exp(lnc1)^(-1/chi(1))*[exp(lnc1)^(1-1/chi(1))+b(1)*[Le-exp(lnl1)]^(1-1/chi(1))]^[(1-1/gamma(1))/(1-1/chi(1))-1]]-exp(lnmu);
f4=lnap1-rho*lna1;

f5=exp(lnmu)*[1+phi*(exp(lnkp2)/exp(lnk2)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap2)+exp(lnap2)*alpha*A*...
    exp(lnkp2)^(mupar(2)-1)*[alpha*exp(lnkp2)^(mupar(2))+(1-alpha)*exp(lnlp2)^(mupar(2))]^(1/mupar(2)-1)];
f5b=b(2)*exp(lnc2)^(1/chi(2))*(Le-exp(lnl2))^(-1/chi(2))-...
    exp(lna2)*(1-alpha)*A*exp(lnl2)^(mupar(2)-1)*[alpha*exp(lnk2)^(mupar(2))+(1-alpha)*exp(lnl2)^(mupar(2))]^(1/mupar(2)-1);
f6=exp(lntheta2)-[1+phi*[1+0.5*(exp(lnkp2)/exp(lnk2)-1)]*(exp(lnkp2)/exp(lnk2)-1)];
f7=[tau(2)*exp(lnc2)^(-1/chi(2))*[exp(lnc2)^(1-1/chi(2))+b(2)*[Le-exp(lnl2)]^(1-1/chi(2))]^[(1-1/gamma(2))/(1-1/chi(2))-1]]-exp(lnmu);
f8=lnap2-rho*lna2;

f9=exp(lnmu)*[1+phi*(exp(lnkp3)/exp(lnk3)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap3)+exp(lnap3)*alpha*A*...
    exp(lnkp3)^(mupar(3)-1)*[alpha*exp(lnkp3)^(mupar(3))+(1-alpha)*exp(lnlp3)^(mupar(3))]^(1/mupar(3)-1)];
f9b=b(3)*exp(lnc3)^(1/chi(3))*(Le-exp(lnl3))^(-1/chi(3))-...
    exp(lna3)*(1-alpha)*A*exp(lnl3)^(mupar(3)-1)*[alpha*exp(lnk3)^(mupar(3))+(1-alpha)*exp(lnl3)^(mupar(3))]^(1/mupar(3)-1);
f10=exp(lntheta3)-[1+phi*[1+0.5*(exp(lnkp3)/exp(lnk3)-1)]*(exp(lnkp3)/exp(lnk3)-1)];
f11=[tau(3)*exp(lnc3)^(-1/chi(3))*[exp(lnc3)^(1-1/chi(3))+b(3)*[Le-exp(lnl3)]^(1-1/chi(3))]^[(1-1/gamma(3))/(1-1/chi(3))-1]]-exp(lnmu);
f12=lnap3-rho*lna3;

f13=exp(lnmu)*[1+phi*(exp(lnkp4)/exp(lnk4)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap4)+exp(lnap4)*alpha*A*...
    exp(lnkp4)^(mupar(4)-1)*[alpha*exp(lnkp4)^(mupar(4))+(1-alpha)*exp(lnlp4)^(mupar(4))]^(1/mupar(4)-1)];
f13b=b(4)*exp(lnc4)^(1/chi(4))*(Le-exp(lnl4))^(-1/chi(4))-...
    exp(lna4)*(1-alpha)*A*exp(lnl4)^(mupar(4)-1)*[alpha*exp(lnk4)^(mupar(4))+(1-alpha)*exp(lnl4)^(mupar(4))]^(1/mupar(4)-1);
f14=exp(lntheta4)-[1+phi*[1+0.5*(exp(lnkp4)/exp(lnk4)-1)]*(exp(lnkp4)/exp(lnk4)-1)];
f15=[tau(4)*exp(lnc4)^(-1/chi(4))*[exp(lnc4)^(1-1/chi(4))+b(4)*[Le-exp(lnl4)]^(1-1/chi(4))]^[(1-1/gamma(4))/(1-1/chi(4))-1]]-exp(lnmu);
f16=lnap4-rho*lna4;

f17=exp(lnmu)*[1+phi*(exp(lnkp5)/exp(lnk5)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap5)+exp(lnap5)*alpha*A*...
    exp(lnkp5)^(mupar(5)-1)*[alpha*exp(lnkp5)^(mupar(5))+(1-alpha)*exp(lnlp5)^(mupar(5))]^(1/mupar(5)-1)];
f17b=b(5)*exp(lnc5)^(1/chi(5))*(Le-exp(lnl5))^(-1/chi(5))-...
    exp(lna5)*(1-alpha)*A*exp(lnl5)^(mupar(5)-1)*[alpha*exp(lnk5)^(mupar(5))+(1-alpha)*exp(lnl5)^(mupar(5))]^(1/mupar(5)-1);
f18=exp(lntheta5)-[1+phi*[1+0.5*(exp(lnkp5)/exp(lnk5)-1)]*(exp(lnkp5)/exp(lnk5)-1)];
f19=[tau(5)*exp(lnc5)^(-1/chi(5))*[exp(lnc5)^(1-1/chi(5))+b(5)*[Le-exp(lnl5)]^(1-1/chi(5))]^[(1-1/gamma(5))/(1-1/chi(5))-1]]-exp(lnmu);
f20=lnap5-rho*lna5;

f21=exp(lnmu)*[1+phi*(exp(lnkp6)/exp(lnk6)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap6)+exp(lnap6)*alpha*A*...
    exp(lnkp6)^(mupar(6)-1)*[alpha*exp(lnkp6)^(mupar(6))+(1-alpha)*exp(lnlp6)^(mupar(6))]^(1/mupar(6)-1)];
f21b=b(6)*exp(lnc6)^(1/chi(6))*(Le-exp(lnl6))^(-1/chi(6))-...
    exp(lna6)*(1-alpha)*A*exp(lnl6)^(mupar(6)-1)*[alpha*exp(lnk6)^(mupar(6))+(1-alpha)*exp(lnl6)^(mupar(6))]^(1/mupar(6)-1);
f22=exp(lntheta6)-[1+phi*[1+0.5*(exp(lnkp6)/exp(lnk6)-1)]*(exp(lnkp6)/exp(lnk6)-1)];
f23=[tau(6)*exp(lnc6)^(-1/chi(6))*[exp(lnc6)^(1-1/chi(6))+b(6)*[Le-exp(lnl6)]^(1-1/chi(6))]^[(1-1/gamma(6))/(1-1/chi(6))-1]]-exp(lnmu);
f24=lnap6-rho*lna6;

f25=exp(lnc1)+exp(lnc2)+exp(lnc3)+exp(lnc4)+exp(lnc5)+exp(lnc6)-exp(lnC);
f26=exp(lnk1)+exp(lnk2)+exp(lnk3)+exp(lnk4)+exp(lnk5)+exp(lnk6)-exp(lnK);

f27=exp(lna1)*A*[alpha*exp(lnk1)^(mupar(1))+(1-alpha)*exp(lnl1)^(mupar(1))]^(1/mupar(1))+...
    exp(lna2)*A*[alpha*exp(lnk2)^(mupar(2))+(1-alpha)*exp(lnl2)^(mupar(2))]^(1/mupar(2))+...
    exp(lna3)*A*[alpha*exp(lnk3)^(mupar(3))+(1-alpha)*exp(lnl3)^(mupar(3))]^(1/mupar(3))+...
    exp(lna4)*A*[alpha*exp(lnk4)^(mupar(4))+(1-alpha)*exp(lnl4)^(mupar(4))]^(1/mupar(4))+...
    exp(lna5)*A*[alpha*exp(lnk5)^(mupar(5))+(1-alpha)*exp(lnl5)^(mupar(5))]^(1/mupar(5))+...
    exp(lna6)*A*[alpha*exp(lnk6)^(mupar(6))+(1-alpha)*exp(lnl6)^(mupar(6))]^(1/mupar(6))-Yss;

f28=exp(lnC)+exp(lnKp)-exp(lnK)-exp(lnY)+...
    phi/2*[exp(lnk1)*(exp(lnkp1)/exp(lnk1)-1)^2+exp(lnk2)*(exp(lnkp2)/exp(lnk2)-1)^2+...
    exp(lnk3)*(exp(lnkp3)/exp(lnk3)-1)^2+exp(lnk4)*(exp(lnkp4)/exp(lnk4)-1)^2+...
    exp(lnk5)*(exp(lnkp5)/exp(lnk5)-1)^2+exp(lnk6)*(exp(lnkp6)/exp(lnk6)-1)^2];

f=[f1;f1b;f2;f3;f4;f5;f5b;f6;f7;f8;f9;f9b;f10;f11;f12;f13;f13b;f14;f15;f16;f17;f17b;f18;f19;f20;f21;f21b;f22;f23;f24;f25;f26;f27;f28];

% 3) Define vectors of states and controls
xx=[lnk1 lnk2 lnk3 lnk4 lnk5 lnk6 lna1 lna2 lna3 lna4 lna5 lna6];
xxp=[lnkp1 lnkp2 lnkp3 lnkp4 lnkp5 lnkp6 lnap1 lnap2 lnap3 lnap4 lnap5 lnap6];

yy=[lnc1 lnc2 lnc3 lnc4 lnc5 lnc6 lntheta1 lntheta2 lntheta3 lntheta4 lntheta5 lntheta6 lnmu lnC lnK lnY lnl1 lnl2 lnl3 lnl4 lnl5 lnl6];
yyp=[lncp1 lncp2 lncp3 lncp4 lncp5 lncp6 lnthetap1 lnthetap2 lnthetap3 lnthetap4 lnthetap5 lnthetap6 lnmup lnCp lnKp lnYp lnlp1 lnlp2 lnlp3 lnlp4 lnlp5 lnlp6];

% 4) Compute analytical derivatives and evaluate them at the steady state
nx = length(xx);
ny = length(yy);

[fx,fxp,fy,fyp,fypyp,fypy,fypxp,fypx,fyyp,fyy,fyxp,fyx,fxpyp,fxpy,...
    fxpxp,fxpx,fxyp,fxy,fxxp,fxx]=anal_deriv(f,xx,yy,xxp,yyp);

assign_steadystate6;
num_eval;

% 5) Construct log-linear approximation using the Klein (2000) algorithm
[gx,hx] = gx_hx(nfy,nfx,nfyp,nfxp);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3. Construct initial guess for decision rule coefficients %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Construct bounds for the state space
tr=1;  % scale parameter
kmin=1/1.1;
kmax=1.1;
amin=exp(-tr*2*sigma/sqrt(1-rho^2));
amax=exp(+tr*2*sigma/sqrt(1-rho^2));

 tr=0.8;  % scale parameter
 kmin=0.8;
 kmax=1.2;
 amin=exp(-tr*sigma/(1-rho));
 amax=exp(+tr*sigma/(1-rho));

% 2) Construct Smolyak Grid
nx = 2*N;
x_Smol = zeros(1,5);
for j = 1:5
  x_Smol(j) = -cos((j-1)*pi/4);
end

%Build Grid
xgrid = zeros(1+4*nx+2*nx*(nx-1),nx);
xgrid = x_Smol(3) * xgrid;
for j = 1:nx
  xgrid(1+4*(j-1)+1,j) = x_Smol(1);
  xgrid(1+4*(j-1)+2,j) = x_Smol(2);
  xgrid(1+4*(j-1)+3,j) = x_Smol(4);
  xgrid(1+4*(j-1)+4,j) = x_Smol(5);
end
ind = 1+4*nx+1;
points1 = [x_Smol(1);x_Smol(1);x_Smol(5);x_Smol(5)];
points2 = [x_Smol(1);x_Smol(5);x_Smol(1);x_Smol(5)];
for j = 1:(nx-1)
  for i = j+1: nx
    xgrid(ind:ind+3,j) = points1;
    xgrid(ind:ind+3,i) = points2;
    ind = ind+4;
  end
end

% Construct state vectors from grid
k1_vec=scalup(xgrid(:,1),kmin,kmax);
k2_vec=scalup(xgrid(:,2),kmin,kmax);
k3_vec=scalup(xgrid(:,3),kmin,kmax);
k4_vec=scalup(xgrid(:,4),kmin,kmax);
k5_vec=scalup(xgrid(:,5),kmin,kmax);
k6_vec=scalup(xgrid(:,6),kmin,kmax);

lna1_vec=scalup(xgrid(:,7),log(amin),log(amax));
lna2_vec=scalup(xgrid(:,8),log(amin),log(amax));
lna3_vec=scalup(xgrid(:,9),log(amin),log(amax));
lna4_vec=scalup(xgrid(:,10),log(amin),log(amax));
lna5_vec=scalup(xgrid(:,11),log(amin),log(amax));
lna6_vec=scalup(xgrid(:,12),log(amin),log(amax));

% Construct regressor matrix to be used for perturbation initialization
INIT_REG=[log(k1_vec)-log(kss) log(k2_vec)-log(kss) log(k3_vec)-log(kss) log(k4_vec)-log(kss) log(k5_vec)-log(kss) log(k6_vec)-log(kss) ...
    lna1_vec-log(ass) lna2_vec-log(ass) lna3_vec-log(ass) lna4_vec-log(ass) lna5_vec-log(ass) lna6_vec-log(ass)];

% Construct next period's capital stocks and current consumption
lnkp1_vec=log(kss)+INIT_REG*hx(1,:)';
lnkp2_vec=log(kss)+INIT_REG*hx(2,:)';
lnkp3_vec=log(kss)+INIT_REG*hx(3,:)';
lnkp4_vec=log(kss)+INIT_REG*hx(4,:)';
lnkp5_vec=log(kss)+INIT_REG*hx(5,:)';
lnkp6_vec=log(kss)+INIT_REG*hx(6,:)';
kp1_vec = exp(lnkp1_vec);
kp2_vec = exp(lnkp2_vec);
kp3_vec = exp(lnkp3_vec);
kp4_vec = exp(lnkp4_vec);
kp5_vec = exp(lnkp5_vec);
kp6_vec = exp(lnkp6_vec);

lnc1_vec=lncss+INIT_REG*gx(1,:)';
lnc2_vec=lncss+INIT_REG*gx(2,:)';
lnc3_vec=lncss+INIT_REG*gx(3,:)';
lnc4_vec=lncss+INIT_REG*gx(4,:)';
lnc5_vec=lncss+INIT_REG*gx(5,:)';
lnc6_vec=lncss+INIT_REG*gx(6,:)';
c1_vec = exp(lnc1_vec);
c2_vec = exp(lnc2_vec);
c3_vec = exp(lnc3_vec);
c4_vec = exp(lnc4_vec);
c5_vec = exp(lnc5_vec);
c6_vec = exp(lnc6_vec);

OUT_VEC=[kp1_vec c1_vec kp2_vec c2_vec kp3_vec c3_vec kp4_vec c4_vec ...
        kp5_vec c5_vec kp6_vec c6_vec];
for j = 1:(1+4*nx+2*nx*(nx-1))
  for i = 1:N
  OUT_VEC1(N*(j-1)+i,:) = OUT_VEC(j,2*i-1:2*i);
  end
end

% Output linearization to .csv file
dlmwrite('initguess6.csv',OUT_VEC1,'delimiter',',','precision',12)
