!******************************************************************************
!
!    Subroutine:  WriteColM
!
!    Purpose: Writes the transpose of a (numeric) Matrix to file.  This 
!             subroutine should be called from a routine that has already 
!             opened a file to be written.
!
!    Author:  Ben Malin
!
!    Date:   10/22/07
!
!******************************************************************************

subroutine WriteColM(Matrix, NR, NC, COL) 
  
  ! inputs:
  !   Matrix -- The matrix to be written.
  !   NR -- The number of rows of the matrix.
  !   NC -- The number of columns to be written.
  !   COL -- Column number to be written.
  !
  ! output:
  ! 
  ! remarks:
  
  use Params
  
  implicit none
  
  ! Input/Output variables
  integer, intent(IN) :: NR   
  integer, intent(IN) :: NC   
  integer, intent(IN) :: COL   
  real(prec), dimension(NR,NC) , intent(IN) :: Matrix
  
  ! Some local variables 
  integer :: j
  
  ! Main part of routine - this writes the transpose of matrix row by row
  
  ! # of rows of the matrix
  do j = 1, NR                                       
   
     ! Writing the matrix row by row            
     write (1, '(F15.12," ")', advance = 'no') Matrix(j,COL)
     
     ! Makes sure that values are separated by a comma   
     write (1, '(",")', advance = 'no')                       
     
  end do
  
end subroutine WriteColM
