!**********************************************************************************
!
!	SUBROUTINE: AccCheck1
!
!	PURPOSE: Computes conditional error functions at a random sample
!                of points at various distances from the deterministic 
!                steady state.
!			 
!	AUTHOR:	 Ben Malin 
!
!	DATE:    7/24/2007
!       REVISED: 4/2009
!**********************************************************************************

subroutine AccCheck1(check1,check2)
  
  ! inputs:
  !   check1 -- denotes whether integration will be done with monomial formula (check1 = 1)
  !            or monte-carlo routine (check1 = 2).
  !   check2 -- denotes whether error in world budget constraint is reported according
  !             to baseline (check2 = 1) or alternative (check2 = 2) specification.
  !
  ! output:
  ! 
  ! remarks:
  !
  
  use Params
  
  implicit none
  
  !Variable Declaration
  integer,intent(in) :: check1, check2

  integer :: i,j	
  integer,parameter :: num = 100*d    !number of random numbers drawn (100 pts * d dims) 
  real(prec),dimension(num) :: nr
  real(prec) :: MaxError

  !Start timer
  call CPU_TIME (time_begin)
  
  !Draw a bunch of random numbers
  call rnset(1)
  call DRNNOA(num,nr)	!IMSL random number generator (normal distribution)
  
  !Divide random numbers into 100 separate points
  do i = 1,100
     accpt(i,:) = nr((i-1)*d + 1 : i*d)
  enddo

  !Calculate maximum error across all equilibrium conditions at a sample of point
  !that lie various distances from the deterministic steady state.
  rad = 0.01
  call AccCheck1Sub(check1,check2,MaxError)
  Acc1Out(1,1) = MaxError
  
  rad = 0.02
  call AccCheck1Sub(check1,check2,MaxError)
  Acc1Out(1,2) = MaxError
  
  rad = 0.05
  call AccCheck1Sub(check1,check2,MaxError)
  Acc1Out(1,3) = MaxError

  rad = 0.10
  call AccCheck1Sub(check1,check2,MaxError)
  Acc1Out(1,4) = MaxError

  rad = 0.15
  call AccCheck1Sub(check1,check2,MaxError)
  Acc1Out(1,5) = MaxError

  rad = 0.20
  call AccCheck1Sub(check1,check2,MaxError)
  Acc1Out(1,6) = MaxError

  rad = 0.30
  call AccCheck1Sub(check1,check2,MaxError)
  Acc1Out(1,7) = MaxError

  !Calculate Running Time
  call CPU_TIME (time_end)
  Acc1_runtime = time_end - time_begin
  
end subroutine AccCheck1
