!***********************************************************************************
!	MODULE:	AltVector
!
!	PURPOSE: Contains subroutine AltVec
!
!	AUTHOR:	Ben Malin
!
!	DATE:	8/7/2007
!       REVISED: 
!***********************************************************************************

module AltVector
  
  use Params
  implicit none
  
contains
  
  !**********************************************************************************
  !
  !	SUBROUTINE: AltVec
  !
  !	PURPOSE: Specifies nle to be solved to compute alternative vector of 
  !                deviations from steady state if the vector used in AccCheck1sub 
  !                implies that a tech shock is out-of-bounds.
  !			 
  !	AUTHOR:	 Ben Malin 
  !
  !	DATE:    8/7/2007
  !     REVISED:
  !**********************************************************************************

  subroutine AltVec(eps,AV,count)
    
    ! inputs:
    !   eps -- increase (decrease) in other state variables needed to keep radius the same
    !   count -- size of eps, count = 1
    !
    ! output:
    !   AV -- outputs value to nonlinear equation solver
    !
    ! remarks:
    !
    
    use Params
    
    implicit none
  
    !Variable Declaration
    integer,intent(in) :: count
    real(prec),dimension(count),intent(in) :: eps
    real(prec),dimension(count),intent(out) :: AV
    
    real(prec) :: peps
    integer :: h
    real(prec),dimension(d) :: temp
    real(prec) :: tempsum
    
    !Transfrom guess to make sure it is positive
    peps = exp(eps(1))

    !Specify nonlinear equation
    do h = 1,N
       if (accptr(pti,h) < 0) then
          temp(h) = accptr(pti,h) - peps
       else
          temp(h) = accptr(pti,h) + peps
       endif
       if (h < ctryj .or. h > ctryj) then
          if (accptr(pti,h+N) < 0) then
             temp(h+N) = accptr(pti,h+N) - peps
          else
             temp(h+N) = accptr(pti,h+N) + peps
          endif
       else
          temp(h+N) = accptr(pti,h+N)
       endif
    enddo
    
    tempsum = 0.0
    do h = 1,N
       tempsum = tempsum + temp(h)*temp(h) + temp(h+N)*temp(h+N)
    enddo
    AV(1) = rad*rad - tempsum 
    
  end subroutine AltVec

end module AltVector
