!*********************************************************************
!
!    Subroutine: PolicyInitial
!
!    Purpose: Sets initial guess for policy function using to 
!              log-linear approximation of solution.
!
!    Author:   Ben Malin
!
!    Date:   6/04
!    Revised: 4/09
!*********************************************************************

subroutine PolicyInitial

  use Params

  implicit none
  
  !Variable Declaration
  integer :: j,i,i1,h,h1
  character(len=10) :: filename 
 
  if (N == 2) then
     filename = "initguess2"
  elseif (N == 4) then
     filename = "initguess4"
  elseif (N == 6) then
     filename = "initguess6"
  elseif (N == 8) then
     filename = "initguess8"
  elseif (N == 10) then
     filename = "initguess9"
  endif

  ! read the data
  open (1, file = filename//".csv")      ! Open file with name filename
  
  open(unit = 40, file = filename//".csv", status = 'old', action = 'read')
  
  !At the origin -- steady-state
  do j = 1,N
     read(40,*) yCap0(j), yCons0(j)
  enddo
  
  !At points3
  do i = 1,d
     do h = 1, 4	
        do j = 1,N
           read(40,*) yCap3(i,h,j), yCons3(i,h,j)
        enddo
     enddo
  enddo
  
  !At points2
  do i = 1,d-1
     do i1 = i+1,d
        do h = 1, 2
           do h1 = 1, 2		
              do j=1,N
                 read(40,*) yCap2(i,i1,h,h1,j), yCons2(i,i1,h,h1,j) 
              enddo
           enddo
        enddo
     enddo
  enddo
  
  close(40)
end subroutine PolicyInitial
