!*********************************************************************
!
!    Subroutine:  ParamUpdate
!
!    Purpose:    Constructs intertemporal elasticity of substitution
!                and other country-specific parameters.
!
!    Author:   Ben Malin
!
!    Date:   7/19/07
!    Revised: 7/23/07
!*********************************************************************

subroutine ParamUpdate
  
  ! inputs:
  !
  ! output:
  ! 
  ! remarks:
  
  use Params
  
  implicit none
  
  !Variable Declaration
  integer :: i

  do i = 1,N
     gamma(i) = gamma_min + real(i-1.0,prec)/real(N-1.0,prec)*(gamma_max - gamma_min)
     xgamma(i) = 1.0/gamma(i)
  end do

 !Construct constants used in f.o.c. for labor supply
  do i = 1,N
     psi(i) = 1.0/((1.0-alpha) * (Le - 1.0) + 1.0)  
     Lfoc(i) = A_tfp * (1.0-alpha) * psi(i) / (1.0 - psi(i))
     psigam1(i) = psi(i) * (1.0 - xgamma(i))
     psigam2(i) = (1.0 - psi(i)) * (1.0 - xgamma(i))
  end do

 !Construct Pareto (Negishi) Weights for each country
  lss = 1.0
  do i = 1,N
     Pareto(i) = 1.0 / Uc(A_tfp, lss, i)
  end do

end subroutine ParamUpdate
