!**********************************************************************************
!
!	SUBROUTINE: GetIndex
!
!	PURPOSE: Converts an index number for a (dim1*dim2) x 1 vector into dim2
!                 index numbers, each for a vector of length dim1.
!
!	AUTHOR:	Ben Malin 
!
!	DATE: 6/2003
!
!**********************************************************************************

subroutine GetIndex(ind, dim1, dim2, multind)
  
  ! inputs:
  !    ind -- index number
  !    dim1,dim2 -- dimensions of matrix 
  !
  ! output:
  !    multind -- holds converted index numbers 
  ! 
  ! remarks:
  !

  implicit none
  
  !Variable Declaration
  integer,intent(in) :: ind,dim1,dim2
  integer,intent(out) :: multind(dim2)
  
  integer :: h,i,j
  integer :: temp = 0
  
  h = dim2
  i = 0
  
  if (dim2 == 1) then
     multind(dim2) = ind
  else
     do while (h > 1)	
        h = h-1	
        do j = 1,dim1
           if ((ind - i) > (j-1)*dim1**h .and. (ind-i) <= j*dim1**h) then
              temp = j
           endif
        end do
        
        multind(dim2 - h) = temp
        i = (temp - 1)*dim1**h + i
     end do
     multind(dim2) = ind - i
  endif
  
end subroutine GetIndex
