% Main file to generate intial guess for solution to model A8
% Approximation is done in levels (k) and logs (a)

clear all

cpu0=cputime;

global N beta alpha delta sigma rho phi A gamma tau psi Le chi b mupar
global kmin kmax amin amax cmin cmax
global xgrid
global k1_mat k2_mat K_mat
global a1_mat a2_mat
global ap1_mat ap2_mat
global y1_mat y2_mat Y_mat
global regvec_labor1 regvec_labor2 mumin mumax

%%%%%%%%%%%%%%%%%%%%%%
% 1. Getting started %
%%%%%%%%%%%%%%%%%%%%%%

approx=1;   % set order of approximation for perturbation solution (initilization)

% 1) Calibration
N=2;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);

gammalow=0.2;
gammahigh=0.4;
gamma=[gammalow:(gammahigh-gammalow)/(N-1):gammahigh];

chilow=0.75;
chihigh=0.9;
chi=[chilow:(chihigh-chilow)/(N-1):chihigh];

muparlow=-0.3;
muparhigh=0.3;
mupar=[muparlow:(muparhigh-muparlow)/(N-1):muparhigh];

Le=2.5;


% 2) Compute the steady state, labor weights and Negishi weights

% a)
kss=1;
lss=1;
Kss=N*kss;
Lss=N*lss;
css=A*kss^alpha*lss^(1-alpha);
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=N*A;

% b) Compute labor weights
b=zeros(1,N);
for j=1:N
    b(j)=(1-alpha)*A^(1-1/chi(j))/[(Le-lss)^(-1/chi(j))];
end

% c) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=[css^(-1/chi(j))*[css^(1-1/chi(j))+b(j)*(Le-lss)^(1-1/chi(j))]^[(1-1/gamma(j))/(1-1/chi(j))-1]]^(-1);
end
muss=1;


% 3) Compute the steady state in logs
lnkss=log(kss);
lnKss=log(Kss);
lncss=log(css);
lnCss=log(Css);
lnthetass=log(thetass);
lnYss=log(Yss);
lnLss=log(Lss);
lnlss=log(lss);
lnmuss=log(muss);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. Construct first-order approximation using method by Klein (2000)  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Define symbolic variables
syms c1 lna1 k1 theta1 cp1 lnap1 kp1 thetap1 l1 lp1
syms c2 lna2 k2 theta2 cp2 lnap2 kp2 thetap2 l2 lp2
syms C Cp K Kp Y Yp CAC CACp mu mup L Lp

syms lnc1 lna1 lnk1 lntheta1 lncp1 lnap1 lnkp1 lnthetap1 lnl1 lnlp1
syms lnc2 lna2 lnk2 lntheta2 lncp2 lnap2 lnkp2 lnthetap2 lnl2 lnlp2
syms lnC lnCp lnK lnKp lnY lnYp CAC CACp lnmu lnmup lnL lnLp

% 2) Construct the system of equilibrium conditions

f1=exp(lnmu)*[1+phi*(exp(lnkp1)/exp(lnk1)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap1)+exp(lnap1)*alpha*A*...
    exp(lnkp1)^(mupar(1)-1)*[alpha*exp(lnkp1)^(mupar(1))+(1-alpha)*exp(lnlp1)^(mupar(1))]^(1/mupar(1)-1)];
f1b=b(1)*exp(lnc1)^(1/chi(1))*(Le-exp(lnl1))^(-1/chi(1))-...
    exp(lna1)*(1-alpha)*A*exp(lnl1)^(mupar(1)-1)*[alpha*exp(lnk1)^(mupar(1))+(1-alpha)*exp(lnl1)^(mupar(1))]^(1/mupar(1)-1);
f2=exp(lntheta1)-[1+phi*[1+0.5*(exp(lnkp1)/exp(lnk1)-1)]*(exp(lnkp1)/exp(lnk1)-1)];
f3=tau(1)*[exp(lnc1)^(-1/chi(1))*[exp(lnc1)^(1-1/chi(1))+b(1)*[Le-exp(lnl1)]^(1-1/chi(1))]^[(1-1/gamma(1))/(1-1/chi(1))-1]]-exp(lnmu);
f4=lnap1-rho*lna1;

f5=exp(lnmu)*[1+phi*(exp(lnkp2)/exp(lnk2)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap2)+exp(lnap2)*alpha*A*...
    exp(lnkp2)^(mupar(2)-1)*[alpha*exp(lnkp2)^(mupar(2))+(1-alpha)*exp(lnlp2)^(mupar(2))]^(1/mupar(2)-1)];
f5b=b(2)*exp(lnc2)^(1/chi(2))*(Le-exp(lnl2))^(-1/chi(2))-...
    exp(lna2)*(1-alpha)*A*exp(lnl2)^(mupar(2)-1)*[alpha*exp(lnk2)^(mupar(2))+(1-alpha)*exp(lnl2)^(mupar(2))]^(1/mupar(2)-1);
f6=exp(lntheta2)-[1+phi*[1+0.5*(exp(lnkp2)/exp(lnk2)-1)]*(exp(lnkp2)/exp(lnk2)-1)];
f7=[tau(2)*exp(lnc2)^(-1/chi(2))*[exp(lnc2)^(1-1/chi(2))+b(2)*[Le-exp(lnl2)]^(1-1/chi(2))]^[(1-1/gamma(2))/(1-1/chi(2))-1]]-exp(lnmu);
f8=lnap2-rho*lna2;

f25=exp(lnc1)+exp(lnc2)-exp(lnC);
f26=exp(lnk1)+exp(lnk2)-exp(lnK);

f27=exp(lna1)*A*[alpha*exp(lnk1)^(mupar(1))+(1-alpha)*exp(lnl1)^(mupar(1))]^(1/mupar(1))+...
    exp(lna2)*A*[alpha*exp(lnk2)^(mupar(2))+(1-alpha)*exp(lnl2)^(mupar(2))]^(1/mupar(2))-Yss;

f28=exp(lnC)+exp(lnKp)-exp(lnK)-exp(lnY)+...
    phi/2*[exp(lnk1)*(exp(lnkp1)/exp(lnk1)-1)^2+exp(lnk2)*(exp(lnkp2)/exp(lnk2)-1)^2];

f=[f1;f1b;f2;f3;f4;f5;f5b;f6;f7;f8;f25;f26;f27;f28];

% 3) Define vectors of states and controls
xx=[lnk1 lnk2 lna1 lna2];
xxp=[lnkp1 lnkp2 lnap1 lnap2];

yy=[lnc1 lnc2 lntheta1 lntheta2 lnmu lnC lnK lnY lnl1 lnl2];
yyp=[lncp1 lncp2 lnthetap1 lnthetap2 lnmup lnCp lnKp lnYp lnlp1 lnlp2];

% 4) Compute analytical derivatives and evaluate them at the steady state
nx = length(xx);
ny = length(yy);

[fx,fxp,fy,fyp,fypyp,fypy,fypxp,fypx,fyyp,fyy,fyxp,fyx,fxpyp,fxpy,...
    fxpxp,fxpx,fxyp,fxy,fxxp,fxx]=anal_deriv(f,xx,yy,xxp,yyp);

assign_steadystate2;
num_eval;

% 5) Construct log-linear approximation using the Klein (2000) algorithm
[gx,hx] = gx_hx(nfy,nfx,nfyp,nfxp);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3. Construct initial guess for decision rule coefficients %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Construct bounds for the state space
tr=1;  % scale parameter
kmin=1/1.1;
kmax=1.1;
amin=exp(-tr*2*sigma/sqrt(1-rho^2));
amax=exp(+tr*2*sigma/sqrt(1-rho^2));

 tr=0.8;  % scale parameter
 kmin=0.8;
 kmax=1.2;
 amin=exp(-tr*sigma/(1-rho));
 amax=exp(+tr*sigma/(1-rho));

% 2) Construct Smolyak Grid
nx = 2*N;
x_Smol = zeros(1,5);
for j = 1:5
  x_Smol(j) = -cos((j-1)*pi/4);
end

%Build Grid
xgrid = zeros(1+4*nx+2*nx*(nx-1),nx);
xgrid = x_Smol(3) * xgrid;
for j = 1:nx
  xgrid(1+4*(j-1)+1,j) = x_Smol(1);
  xgrid(1+4*(j-1)+2,j) = x_Smol(2);
  xgrid(1+4*(j-1)+3,j) = x_Smol(4);
  xgrid(1+4*(j-1)+4,j) = x_Smol(5);
end
ind = 1+4*nx+1;
points1 = [x_Smol(1);x_Smol(1);x_Smol(5);x_Smol(5)];
points2 = [x_Smol(1);x_Smol(5);x_Smol(1);x_Smol(5)];
for j = 1:(nx-1)
  for i = j+1: nx
    xgrid(ind:ind+3,j) = points1;
    xgrid(ind:ind+3,i) = points2;
    ind = ind+4;
  end
end

% Construct state vectors from grid
k1_vec=scalup(xgrid(:,1),kmin,kmax);
k2_vec=scalup(xgrid(:,2),kmin,kmax);

lna1_vec=scalup(xgrid(:,3),log(amin),log(amax));
lna2_vec=scalup(xgrid(:,4),log(amin),log(amax));

% Construct regressor matrix to be used for perturbation initialization
INIT_REG=[log(k1_vec)-log(kss) log(k2_vec)-log(kss) ...
    lna1_vec-log(ass) lna2_vec-log(ass)];

% Construct next period's capital stocks and current consumption
lnkp1_vec=log(kss)+INIT_REG*hx(1,:)';
lnkp2_vec=log(kss)+INIT_REG*hx(2,:)';
kp1_vec = exp(lnkp1_vec);
kp2_vec = exp(lnkp2_vec);

lnc1_vec=lncss+INIT_REG*gx(1,:)';
lnc2_vec=lncss+INIT_REG*gx(2,:)';
c1_vec = exp(lnc1_vec);
c2_vec = exp(lnc2_vec);

OUT_VEC=[kp1_vec c1_vec kp2_vec c2_vec];
for j = 1:(1+4*nx+2*nx*(nx-1))
  for i = 1:N
  OUT_VEC1(N*(j-1)+i,:) = OUT_VEC(j,2*i-1:2*i);
  end
end

% Output linearization to .csv file
dlmwrite('initguess2.csv',OUT_VEC1,'delimiter',',','precision',12)
