!*********************************************************************
!
!    Subroutine:  Output
!
!    Purpose:    Produces Output File
!                Writes output to a .csv file.
!
!    Author:   Ben Malin
!
!    Date:   7/6/07
!    Revised: 7/26/07
!*********************************************************************

subroutine Output(filename)

  ! inputs:
  !   filename -- name of output file
  !
  ! output:
  ! 
  ! remarks:
  
  use Params

  implicit none
  
  ! Variable Declaration
  character(len=4), intent(IN) :: filename 
 
  character(len=9), dimension(1,13) :: ParamNames
  real(prec), dimension(1,13) :: ParamOut
  character(len=9), dimension(1,10) :: VarNames
  character(len=9), dimension(1,8) :: CompNames
  character(len=9), dimension(1,7) :: Acc1Names
  character(len=9), dimension(1,11) :: Acc2Names
  character(len=9), dimension(1,3) :: Acc3Names
  integer :: i
  
  !Matrix that holds parameter names & run times
  ParamNames(1,1) = "rho"
  ParamNames(1,2) = "sigma"
  ParamNames(1,3) = "phi"
  ParamNames(1,4) = "gamma"
  ParamNames(1,5) = "N"
  ParamNames(1,6) = "kss"
  ParamNames(1,7) = "kmin"
  ParamNames(1,8) = "kmax"
  ParamNames(1,9) = "Sol Time"
  ParamNames(1,10) = "Acc1 Time"
  ParamNames(1,11) = "Acc2 Time"
  ParamNames(1,12) = "Acc3 Time"
  ParamNames(1,13) = "Accel"

  !Matrix that holds parameter values
  ParamOut(1,1) = rho
  ParamOut(1,2) = sigma
  ParamOut(1,3) = kappa
  ParamOut(1,4) = gamma
  ParamOut(1,5) = real(N,prec)
  ParamOut(1,6) = kss
  ParamOut(1,7) = kmin
  ParamOut(1,8) = kmax
  ParamOut(1,9) = policy_runtime
  ParamOut(1,10) = Acc1_runtime
  ParamOut(1,11) = Acc2_runtime
  ParamOut(1,12) = Acc3_runtime
  ParamOut(1,13) = acc

  !Matrix that holds variable names
  VarNames(1,1) = "K(ownK)"
  VarNames(1,2) = "K(othK)"
  VarNames(1,3) = "K(ownZ)"
  VarNames(1,4) = "K(othZ)"
  VarNames(1,5) = "C(ownK)"
  VarNames(1,6) = "C(othK)"
  VarNames(1,7) = "C(ownZ)"
  VarNames(1,8) = "C(othZ)"
  VarNames(1,9) = "Knorm"
  VarNames(1,10) = "Znorm"

  !Matrix that holds variable names
  CompNames(1,1) = "C_1"
  CompNames(1,2) = "C_2"
  CompNames(1,3) = "L_1"
  CompNames(1,4) = "L_2"
  CompNames(1,5) = "K'_1"
  CompNames(1,6) = "K'_2"
  CompNames(1,7) = "I_1"
  CompNames(1,8) = "I_2"

  !Matrix that holds names for output from Accuracy Check 1
  Acc1Names(1,1) = "r=.01"
  Acc1Names(1,2) = "r=.02"
  Acc1Names(1,3) = "r=.05"
  Acc1Names(1,4) = "r=.10"
  Acc1Names(1,5) = "r=.15"
  Acc1Names(1,6) = "r=.20"
  Acc1Names(1,7) = "r=.30"

  !Matrix that holds names for output from Accuracy Check 2
  Acc2Names(1,1) = "MaxEEerr"
  Acc2Names(1,2) = "MaxCerr"
  Acc2Names(1,3) = "MaxBCerr"
  Acc2Names(1,4) = "AvgEEerr"
  Acc2Names(1,5) = "AvgCerr"
  Acc2Names(1,6) = "AvgBCerr"
  Acc2Names(1,7) = "mincap"
  Acc2Names(1,8) = "maxcap"
  Acc2Names(1,9) = "mincons"
  Acc2Names(1,10) = "minz"
  Acc2Names(1,11) = "maxz"

  !Matrix that holds names for output from Accuracy Check 3
  Acc3Names(1,1) = "P_05"
  Acc3Names(1,2) = "P_50"
  Acc3Names(1,3) = "P_95"

  ! Write output to file
  print*,""
  print*,""
  print*,""
  print*,"Make sure the output file -> ", filename, ".csv <- is closed!"
  print*,""
  print*,""
  print*,""
!  pause
  
  open (1, file = filename//".csv")      ! Open file with name filename

  !Outputs the parameters of the model
  call WriteRowT(ParamNames, 1, 13, 1)
  write (1,"") 
  call WriteRowM(ParamOut, 1, 13, 1)
  write (1,"") 
  write (1,"") 

  !Outputs the state variable grids and decision rules
  call WriteRowT(VarNames, 1, 10, 1)
  write (1,"") 

  do i = 1, nk
     call WriteRowM(VarOut, nk, 10, i)
     write (1,"")                                                
  end do

  !Outputs errors from Accuracy Check 1
  write (1,"") 
  call WriteRowT(Acc1Names, 1, 7, 1)
  write (1,"") 

  call WriteRowM(Acc1Out, 1, 7, 1)
  write (1,"")                                                

  !Outputs errors and other variables from Accuracy Check 2
  write (1,"") 
  call WriteRowT(Acc2Names, 1, 11, 1)
  write (1,"") 

  do i = 1, N
     call WriteRowM(Acc2Out, N, 11, i)
     write (1,"")                                                
  end do

  !Outputs errors and other variables from Accuracy Check 3
  write (1,"") 
  call WriteRowT(Acc3Names, 1, 3, 1)
  write (1,"") 

  call WriteRowM(Acc3Out, 1, 3, 1)
  write (1,"")                                                
  
  !Outputs policy functions for comparison project
  call WriteRowT(CompNames, 1, 8, 1)
  write (1,"") 

  do i = 1, nk
     call WriteRowM(OwnOut, nk, 8, i)
     write (1,"")                                                
  end do
  do i = 1, nk
     call WriteRowM(OthOut, nk, 8, i)
     write (1,"")                                                
  end do
  do i = 1, nz
     call WriteRowM(OwnSOut, nz, 8, i)
     write (1,"")                                                
  end do
  do i = 1, nz
     call WriteRowM(OthSOut, nz, 8, i)
     write (1,"")                                                
  end do

  print*,""
  print*,""
  print*,""
  print*,"Results were written to file -> ", filename, ".csv", " <-"
  print*,""
  print*,""
  print*,""
  
end subroutine Output
