!******************************************************************************
!
!    Subroutine:  WriteRowM
!
!    Purpose: Writes a (numeric) Matrix to file.  This subroutine should be
!             called from a routine that has already opened a file to
!             be written.
!
!    Author:   Felix Reichling - Ben Malin
!
!    Date:   5/24/07
!
!******************************************************************************

subroutine WriteRowM(Matrix, NR, NC, row) 
  
  ! inputs:
  !   Matrix -- The matrix to be written.
  !   NR -- The number of rows of the matrix.
  !   NC -- The number of columns to be written.
  !   Row -- Row number to be written.
  !
  ! output:
  ! 
  ! remarks:
  
  use Params
  
  implicit none
  
  ! Input/Output variables
  integer, intent(IN) :: NR   
  integer, intent(IN) :: NC   
  integer, intent(IN) :: ROW   
  real(prec), dimension(NR,NC) , intent(IN) :: Matrix
  
  ! Some local variables 
  integer :: j
  
  ! Main part of routine - this writes matrices row by row
  
  ! # of columns of the matrix   
  do j = 1, NC                                       
   
     ! Writing the matrix row by row            
     write (1, '(F20.16," ")', advance = 'no') Matrix(row,j)
     
     ! Makes sure that values are separated by a comma   
     write (1, '(",")', advance = 'no')                       
     
  end do
  
end subroutine WriteRowM

   
