!*********************************************************************
!
!    Subroutine:  ParamUpdate
!
!    Purpose:    Constructs intertemporal elasticity of substitution
!                and Negishi weight for each country.
!
!    Author:   Ben Malin
!
!    Date:   6/04
!    Revised: 7/30/07
!*********************************************************************

subroutine ParamUpdate
  
  ! inputs:
  !
  ! output:
  ! 
  ! remarks:
  
  use Params
  
  implicit none
  
  !Variable Declaration
  integer :: i

  do i = 1,N
     gamma(i) = gamma_min + real(i-1.0,prec)/real(N-1.0,prec)*(gamma_max - gamma_min)
     xgamma(i) = 1.0/gamma(i)
  end do

 !Construct Pareto (Negishi) Weights for each country
  do i = 1,N
     Pareto(i) = 1.0 / Uc(A_tfp,i)
  end do

end subroutine ParamUpdate
