!*********************************************************************
!
!    Subroutine:  ParamUpdate
!
!    Purpose:    Constructs intertemporal elasticity of substitution
!                and labor supply elasticity for each country.
!
!    Author:   Ben Malin
!
!    Date:   7/19/07
!    Revised: 7/23/07
!*********************************************************************

subroutine ParamUpdate
  
  ! inputs:
  !
  ! output:
  ! 
  ! remarks:
  
  use Params
  
  implicit none
  
  !Variable Declaration
  integer :: i

  do i = 1,N
     gamma(i) = gamma_min + real(i-1.0,prec)/real(N-1.0,prec)*(gamma_max - gamma_min)
     xgamma(i) = 1.0/gamma(i)
     eta(i) = eta_min + real(i-1.0,prec)/real(N-1.0,prec)*(eta_max - eta_min)
     xeta(i) = 1.0/eta(i)
  end do

 !Construct Pareto (Negishi) Weights for each country
  do i = 1,N
     Pareto(i) = 1.0 / Uc(A_tfp,i)
  end do

 !Construct used in f.o.c. for labor supply
  do i = 1,N
     b(i) = (1.0-alpha) * A_tfp**(1.0-xgamma(i))  
     Lfoc(i) = A_tfp * (1.0-alpha) / b(i)
     Lelast(i) = 1.0 / (xeta(i) + alpha) 
  end do

end subroutine ParamUpdate
