!***********************************************************************************
!	MODULE:	InitGuess
!
!	PURPOSE: Contains subroutine InitCons
!
!	AUTHOR:	Ben Malin
!
!	DATE:	7/20/2007
!       REVISED: 
!
!***********************************************************************************

module InitGuess
  
  use Params

  implicit none
  
contains
  
  !***********************************************************************************
  !
  !	SUBROUTINE:  InitCons
  !
  !	PURPOSE: Specifies equation whose solution is the initial guess for
  !               country 1's consumption.
  !
  !	AUTHOR:	 Ben Malin 
  !
  !	DATE:    7/20/2007
  !     REVISED: 
  !
  !***********************************************************************************

  subroutine InitCons(pol,ICons,count)
    
    ! inputs:
    !    pol -- Holds guess of nonlinear equation solver
    !    count -- size of pol vector -- 1
    !
    ! output:
    !    ICons -- Values of equation evaluated at pol.
    ! 
    ! remarks:
    !    Pol(1) is tomorrow's (log) consumption for country 1.
    !
    
    use Params

    implicit none
        
    !Variable Declaration
    integer,intent(in) :: count	
    real(prec),dimension(count),intent(in) :: pol	
    real(prec),dimension(count),intent(out) :: ICons
    
    real(prec) :: cons
    integer :: i

    !Transform guess from log(c) to c
    cons = exp(pol(1))

    !Construct equation
    ICons = 0.0
    do i = 1,N
       ICons = ICons + (Pareto(1)/Pareto(i))**(1.0/(psigam1(i)-1.0)) * &
            & cons**((psigam1(1)-1.0)/(psigam1(i)-1.0))
    end do
    ICons = ICons - aggC

  end subroutine InitCons

end module InitGuess
