!****************************************************************************
!
!   Program: Main
!
!   Purpose: *Uses Policy Function Iteration with Smolyak Interpolation
! 	      and Integration by a Monomial formula (7.5.11 in Judd)
! 	      to solve the IRBC model specified by Krueger/Kubler/Malin.
! 	     *Specification A8 as described by den Haan, Judd, and Juillard.
!            *The production function represents net output. 
!            *Technological shocks are generated by an AR(1) process 
! 	      with innovations drawn from a std. normal distribution. There
!             is an aggregate shock as well as country-specific shocks. 
!            *The code is general in that it does not assume symmetric
! 	      Pareto weights for the countries. Since countries have
!             different parameters for their utility functions, it is also
!             helpful to have an asymmetric capital grid.
!            *State variables: k & ln(a)
!            *Policy functions: k', l, & c
!           
!   Author:  Ben Malin
!
!   Date:    6/2004
!   Revised: 4/2009
!*****************************************************************************

program Main
  
  use Params	!Contains parameter specifications and global variables/functions
  
  implicit none
  
  ! Output to csv files, which are then transfered to excel file OutputN_x_y_z
  ! N = number of countries
  ! x = 1 (gam_m = 0.2, gam_M = 0.4)
  ! y = 1 corresp to var low (sigma = 0.001, rho = 0.8), y = 2 to var high (sigma = 0.01, rho = 0.95).
  ! z = 1 corresp to acc = .50, z = 2 to  acc = 1, z = 3 to acc = 1.5 (if z is missing, acc = 1.5).
 
  !Variable Declaration
  character(len=4) :: outfile
  character(len=6) :: cofile

  !Sets printing and stopping rules conditional on an error in IMSL routine.
  call ERSET(0,-1,1)    !Note that this is an IMSL subroutine.
  
  !Sets parameters that are country-specific
  call ParamUpdate      
  
  !Constructs grid of smolyak points, weights for integrations, etc.
  call Grid		
  
  !Sets initial guess for policy function
  call PolicyInitial	
  
  !Compute solution and results and output to file for adj cost param = 0.5
  kappa = 0.5
  call Policy
  cofile = "coeff2"
  call OutCoeff(cofile) !Outputs coefficients of policy functions to file
  call DecRule		!Computes policy function at specified points
  call DecRule2	        !Computes policy function at specified points for comparison project
  call AccCheck1(1,2)   !Runs accuracy check #1 (described by den Haan, Judd, Juillard)
  call AccCheck2(1,2)	!Runs accuracy check #2, using monomial formula integration
  !call AccCheck2(2,1)	!Runs accuracy check #2, using monte carlo integration
  !call AccCheck3	!Runs accuracy check #3.
  outfile = "out1"
  call Output(outfile)  !Outputs results to file

end program Main
