!*********************************************************************
!
!    Subroutine:  ParamUpdate
!
!    Purpose:    Constructs country-specific parameters.
!
!    Author:   Ben Malin
!
!    Date:   7/20/07
!    Revised: 8/3/07
!*********************************************************************

subroutine ParamUpdate
  
  ! inputs:
  !
  ! output:
  ! 
  ! remarks:
  
  use Params
  
  implicit none
  
  !Variable Declaration
  integer :: i

  do i = 1,N
     gamma(i) = gamma_min + real(i-1.0,prec)/real(N-1.0,prec)*(gamma_max - gamma_min)
     xgamma(i) = 1.0/gamma(i)
     chi(i) = chi_min + real(i-1.0,prec)/real(N-1.0,prec)*(chi_max - chi_min)
     xchi(i) = 1.0/chi(i)
     chigam(i) = xchi(i) - xgamma(i)
     ychi(i) = 1.0 - xchi(i)
     muh(i) = muh_min + real(i-1.0,prec)/real(N-1.0,prec)*(muh_max - muh_min)
     xmuh(i) = 1.0/muh(i)
  end do

 !Construct constants used in f.o.c. for labor supply
  do i = 1,N
     b(i) = (1.0 - alpha) * A_tfp * ((Le - 1.0)/(A_tfp))**xchi(i)
     Lfoc(i) = A_tfp * (1.0-alpha) / b(i)
  end do

 !Construct Pareto (Negishi) Weights for each country
  lss = 1.0
  do i = 1,N
     Pareto(i) = 1.0 / Uc(A_tfp, lss, i)
  end do

end subroutine ParamUpdate
