% Main file to solve model A1 with N=10

clear all

cpu0=cputime;

global N beta alpha delta sigma rho phi A gamma tau ord
global kmin kmax amin amax
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat k3_mat k4_mat k5_mat k6_mat k7_mat k8_mat k9_mat k10_mat  K_mat
global a1_mat a2_mat a3_mat a4_mat a5_mat a6_mat a7_mat a8_mat a9_mat a10_mat
global ap1_mat ap2_mat ap3_mat ap4_mat ap5_mat ap6_mat ap7_mat ap8_mat ap9_mat ap10_mat
global y1_mat y2_mat y3_mat y4_mat y5_mat y6_mat y7_mat y8_mat y9_mat y10_mat Y_mat
global cheby_ap1_mat cheby_ap2_mat cheby_ap3_mat
global cheby_ap4_mat cheby_ap5_mat cheby_ap6_mat
global cheby_ap7_mat cheby_ap8_mat cheby_ap9_mat cheby_ap10_mat 
global regvec C_min C_max

%%%%%%%%%%%%%%%%%%%%%%
% 1. Getting started %
%%%%%%%%%%%%%%%%%%%%%%

approx=1;   % set order of approximation for perturbation solution (initilization)
ord=2;      % set order of approximation for monomial Galerkin method

kmin=0.95;  % Set bounds for the state space
kmax=1.05;
amin=exp(-0.05);
amax=exp(+0.05);


% 1) Calibration
N=10;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);
gamma=ones(1,N);

% 2) Compute the steady state and the Negishi weights
kss=1;
Kss=N*kss;
css=A*kss^alpha;
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=N*A*kss^alpha;


% 3) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=css^(1/gamma(j));
end
muss=1;


% 4) Compute the steady state in logs
lnkss=log(kss);
lnKss=log(Kss);
lncss=log(css);
lnCss=log(Css);
lnthetass=log(thetass);
lnYss=log(Yss);
lnmuss=log(muss);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. Construct first-order approximation using method by Klein (2000)  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Define symbolic variables
syms c1 lna1 k1 theta1 cp1 lnap1 kp1 thetap1
syms c2 lna2 k2 theta2 cp2 lnap2 kp2 thetap2
syms c3 lna3 k3 theta3 cp3 lnap3 kp3 thetap3
syms c4 lna4 k4 theta4 cp4 lnap4 kp4 thetap4
syms c5 lna5 k5 theta5 cp5 lnap5 kp5 thetap5
syms c6 lna6 k6 theta6 cp6 lnap6 kp6 thetap6
syms c7 lna7 k7 theta7 cp7 lnap7 kp7 thetap7
syms c8 lna8 k8 theta8 cp8 lnap8 kp8 thetap8
syms c9 lna9 k9 theta9 cp9 lnap9 kp9 thetap9
syms c10 lna10 k10 theta10 cp10 lnap10 kp10 thetap10
syms C Cp K Kp Y Yp CAC CACp mu mup

% 1) Define symbolic variables
syms lnc1 lna1 lnk1 lntheta1 lncp1 lnap1 lnkp1 lnthetap1
syms lnc2 lna2 lnk2 lntheta2 lncp2 lnap2 lnkp2 lnthetap2
syms lnc3 lna3 lnk3 lntheta3 lncp3 lnap3 lnkp3 lnthetap3
syms lnc4 lna4 lnk4 lntheta4 lncp4 lnap4 lnkp4 lnthetap4
syms lnc5 lna5 lnk5 lntheta5 lncp5 lnap5 lnkp5 lnthetap5
syms lnc6 lna6 lnk6 lntheta6 lncp6 lnap6 lnkp6 lnthetap6
syms lnc7 lna7 lnk7 lntheta7 lncp7 lnap7 lnkp7 lnthetap7
syms lnc8 lna8 lnk8 lntheta8 lncp8 lnap8 lnkp8 lnthetap8
syms lnc9 lna9 lnk9 lntheta9 lncp9 lnap9 lnkp9 lnthetap9
syms lnc10 lna10 lnk10 lntheta10 lncp10 lnap10 lnkp10 lnthetap10
syms lnC lnCp lnK lnKp lnY lnYp CAC CACp lnmu lnmup


% 2) Construct the system of equilibrium conditions

f1=exp(lnc1)^(-1/gamma(1))*[1+phi*(exp(lnkp1)/exp(lnk1)-1)]-beta*exp(lncp1)^(-1/gamma(1))*[exp(lnthetap1)+exp(lnap1)*A*alpha*exp(lnkp1)^(alpha-1)];
f2=exp(lntheta1)-[1-delta+phi/2*(exp(lnkp1)/exp(lnk1)-1)*(exp(lnkp1)/exp(lnk1)+1)];
f3=tau(1)*exp(lnc1)^(-1/gamma(1))-exp(lnmu);
f4=lnap1-rho*lna1;

f5=exp(lnc2)^(-1/gamma(2))*[1+phi*(exp(lnkp2)/exp(lnk2)-1)]-beta*exp(lncp2)^(-1/gamma(2))*[exp(lnthetap2)+exp(lnap2)*A*alpha*exp(lnkp2)^(alpha-1)];
f6=exp(lntheta2)-[1-delta+phi/2*(exp(lnkp2)/exp(lnk2)-1)*(exp(lnkp2)/exp(lnk2)+1)];
f7=tau(2)*exp(lnc2)^(-1/gamma(2))-exp(lnmu);
f8=lnap2-rho*lna2;

f9=exp(lnc3)^(-1/gamma(3))*[1+phi*(exp(lnkp3)/exp(lnk3)-1)]-beta*exp(lncp3)^(-1/gamma(3))*[exp(lnthetap3)+exp(lnap3)*A*alpha*exp(lnkp3)^(alpha-1)];
f10=exp(lntheta3)-[1-delta+phi/2*(exp(lnkp3)/exp(lnk3)-1)*(exp(lnkp3)/exp(lnk3)+1)];
f11=tau(3)*exp(lnc3)^(-1/gamma(3))-exp(lnmu);
f12=lnap3-rho*lna3;

f13=exp(lnc4)^(-1/gamma(4))*[1+phi*(exp(lnkp4)/exp(lnk4)-1)]-beta*exp(lncp4)^(-1/gamma(4))*[exp(lnthetap4)+exp(lnap4)*A*alpha*exp(lnkp4)^(alpha-1)];
f14=exp(lntheta4)-[1-delta+phi/2*(exp(lnkp4)/exp(lnk4)-1)*(exp(lnkp4)/exp(lnk4)+1)];
f15=tau(4)*exp(lnc4)^(-1/gamma(4))-exp(lnmu);
f16=lnap4-rho*lna4;

f17=exp(lnc5)^(-1/gamma(5))*[1+phi*(exp(lnkp5)/exp(lnk5)-1)]-beta*exp(lncp5)^(-1/gamma(5))*[exp(lnthetap5)+exp(lnap5)*A*alpha*exp(lnkp5)^(alpha-1)];
f18=exp(lntheta5)-[1-delta+phi/2*(exp(lnkp5)/exp(lnk5)-1)*(exp(lnkp5)/exp(lnk5)+1)];
f19=tau(5)*exp(lnc5)^(-1/gamma(5))-exp(lnmu);
f20=lnap5-rho*lna5;

f21=exp(lnc6)^(-1/gamma(6))*[1+phi*(exp(lnkp6)/exp(lnk6)-1)]-beta*exp(lncp6)^(-1/gamma(6))*[exp(lnthetap6)+exp(lnap6)*A*alpha*exp(lnkp6)^(alpha-1)];
f22=exp(lntheta6)-[1-delta+phi/2*(exp(lnkp6)/exp(lnk6)-1)*(exp(lnkp6)/exp(lnk6)+1)];
f23=tau(6)*exp(lnc6)^(-1/gamma(6))-exp(lnmu);
f24=lnap6-rho*lna6;

f25=exp(lnc7)^(-1/gamma(7))*[1+phi*(exp(lnkp7)/exp(lnk7)-1)]-beta*exp(lncp7)^(-1/gamma(7))*[exp(lnthetap7)+exp(lnap7)*A*alpha*exp(lnkp7)^(alpha-1)];
f26=exp(lntheta7)-[1-delta+phi/2*(exp(lnkp7)/exp(lnk7)-1)*(exp(lnkp7)/exp(lnk7)+1)];
f27=tau(7)*exp(lnc7)^(-1/gamma(7))-exp(lnmu);
f28=lnap7-rho*lna7;

f29=exp(lnc8)^(-1/gamma(8))*[1+phi*(exp(lnkp8)/exp(lnk8)-1)]-beta*exp(lncp8)^(-1/gamma(8))*[exp(lnthetap8)+exp(lnap8)*A*alpha*exp(lnkp8)^(alpha-1)];
f30=exp(lntheta8)-[1-delta+phi/2*(exp(lnkp8)/exp(lnk8)-1)*(exp(lnkp8)/exp(lnk8)+1)];
f31=tau(8)*exp(lnc8)^(-1/gamma(8))-exp(lnmu);
f32=lnap8-rho*lna8;

f33=exp(lnc9)^(-1/gamma(9))*[1+phi*(exp(lnkp9)/exp(lnk9)-1)]-beta*exp(lncp9)^(-1/gamma(9))*[exp(lnthetap9)+exp(lnap9)*A*alpha*exp(lnkp9)^(alpha-1)];
f34=exp(lntheta9)-[1-delta+phi/2*(exp(lnkp9)/exp(lnk9)-1)*(exp(lnkp9)/exp(lnk9)+1)];
f35=tau(9)*exp(lnc9)^(-1/gamma(9))-exp(lnmu);
f36=lnap9-rho*lna9;

f37=exp(lnc10)^(-1/gamma(10))*[1+phi*(exp(lnkp10)/exp(lnk10)-1)]-beta*exp(lncp10)^(-1/gamma(10))*[exp(lnthetap10)+exp(lnap10)*A*alpha*exp(lnkp10)^(alpha-1)];
f38=exp(lntheta10)-[1-delta+phi/2*(exp(lnkp10)/exp(lnk10)-1)*(exp(lnkp10)/exp(lnk10)+1)];
f39=tau(10)*exp(lnc10)^(-1/gamma(10))-exp(lnmu);
f40=lnap10-rho*lna10;


f41=exp(lnc1)+exp(lnc2)+exp(lnc3)+exp(lnc4)+exp(lnc5)+exp(lnc6)+exp(lnc7)+exp(lnc8)+exp(lnc9)+exp(lnc10)-exp(lnC);
f42=exp(lnk1)+exp(lnk2)+exp(lnk3)+exp(lnk4)+exp(lnk5)+exp(lnk6)+exp(lnk7)+exp(lnk8)+exp(lnk9)+exp(lnk10)-exp(lnK);
f43=exp(lna1)*A*exp(lnk1)^alpha+exp(lna2)*A*exp(lnk2)^alpha+exp(lna3)*A*exp(lnk3)^alpha+exp(lna4)*A*exp(lnk4)^alpha+...
    exp(lna5)*A*exp(lnk5)^alpha+exp(lna6)*A*exp(lnk6)^alpha+exp(lna7)*A*exp(lnk7)^alpha+exp(lna8)*A*exp(lnk8)^alpha+...
    exp(lna9)*A*exp(lnk9)^alpha+exp(lna10)*A*exp(lnk10)^alpha-exp(lnY);
f44=exp(lnC)+exp(lnKp)-(1-delta)*exp(lnK)-exp(lnY)+...
    phi/2*[exp(lnk1)*(exp(lnkp1)/exp(lnk1)-1)^2+exp(lnk2)*(exp(lnkp2)/exp(lnk2)-1)^2+exp(lnk3)*(exp(lnkp3)/exp(lnk3)-1)^2+...
    exp(lnk4)*(exp(lnkp4)/exp(lnk4)-1)^2+exp(lnk5)*(exp(lnkp5)/exp(lnk5)-1)^2+exp(lnk6)*(exp(lnkp6)/exp(lnk6)-1)^2+...
    exp(lnk7)*(exp(lnkp7)/exp(lnk7)-1)^2+exp(lnk8)*(exp(lnkp8)/exp(lnk8)-1)^2+exp(lnk9)*(exp(lnkp9)/exp(lnk9)-1)^2+...
    exp(lnk10)*(exp(lnkp10)/exp(lnk10)-1)^2];

f=[f1;f2;f3;f4;f5;f6;f7;f8;f9;f10;f11;f12;f13;f14;f15;f16;f17;f18;f19;f20;f21;f22;f23;f24;f25;f26;f27;f28;f29;f30;...
    f31;f32;f33;f34;f35;f36;f37;f38;f39;f40;f41;f42;f43;f44];

% 3) Define vectors of states and controls
xx=[lnk1 lnk2 lnk3 lnk4 lnk5 lnk6 lnk7 lnk8 lnk9 lnk10 lna1 lna2 lna3 lna4 lna5 lna6 lna7 lna8 lna9 lna10];
xxp=[lnkp1 lnkp2 lnkp3 lnkp4 lnkp5 lnkp6 lnkp7 lnkp8 lnkp9 lnkp10 ...
    lnap1 lnap2 lnap3 lnap4 lnap5 lnap6 lnap7 lnap8 lnap9 lnap10];

yy=[lnc1 lnc2 lnc3 lnc4 lnc5 lnc6 lnc7 lnc8 lnc9 lnc10 lntheta1 lntheta2 lntheta3 lntheta4 lntheta5 lntheta6 ...
    lntheta7 lntheta8 lntheta9 lntheta10 lnmu lnC lnK lnY];
yyp=[lncp1 lncp2 lncp3 lncp4 lncp5 lncp6 lncp7 lncp8 lncp9 lncp10 lnthetap1 lnthetap2 lnthetap3 lnthetap4 ...
    lnthetap5 lnthetap6 lnthetap7 lnthetap8 lnthetap9 lnthetap10 lnmup lnCp lnKp lnYp];

% 4) Compute analytical derivatives and evaluate them at the steady state
nx = length(xx);
ny = length(yy);

[fx,fxp,fy,fyp,fypyp,fypy,fypxp,fypx,fyyp,fyy,fyxp,fyx,fxpyp,fxpy,...
    fxpxp,fxpx,fxyp,fxy,fxxp,fxx]=anal_deriv(f,xx,yy,xxp,yyp);

assign_steadystate;
num_eval;

% 5) Construct log-linear approximation using the Klein (2000) algorithm
[gx,hx] = gx_hx(nfy,nfx,nfyp,nfxp);

if approx==2; 
etamat=zeros(nx,N+1);
for jj=1:N
    etamat(nx/2+jj,1)=sigma;
    etamat(nx/2+jj,1+jj)=sigma;
end
[GXX,HXX] = gxx_hxx_sparse(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx);
[GSS,HSS] = gss_hss(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx,GXX,etamat);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3. Construct initial guess for decision rule coefficients %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% 2) Construct monomial grid (Integration formula Cn:5.2 in Stroud (1971))
nx=20;
r_Mon=sqrt(3/5);
V_MON=2^nx;
B0_MON=(25*nx^2-115*nx+162)/162*V_MON;
B1_MON=(70-25*nx)/162*V_MON;
B2_MON=25/324*V_MON;

% build grid	
xgrid=zeros(2*nx^2+1,nx);
for j=1:nx
xgrid(2*j,j)=r_Mon;
xgrid(2*j+1,j)=-r_Mon;
end

ind=1+2*nx+1;
interim=[r_Mon r_Mon;r_Mon -r_Mon;-r_Mon r_Mon;-r_Mon -r_Mon];

for j=1:(nx-1)
    for i=j+1:nx
        xgrid(ind:ind+3,j)=interim(:,1);
        xgrid(ind:ind+3,i)=interim(:,2);
        ind=ind+4;
    end
end

% Construct Chebyshev polynomials from grid
Cheby_k1=chebpol_2(ord,xgrid(:,1));
Cheby_k2=chebpol_2(ord,xgrid(:,2));
Cheby_k3=chebpol_2(ord,xgrid(:,3));
Cheby_k4=chebpol_2(ord,xgrid(:,4));
Cheby_k5=chebpol_2(ord,xgrid(:,5));
Cheby_k6=chebpol_2(ord,xgrid(:,6));
Cheby_k7=chebpol_2(ord,xgrid(:,7));
Cheby_k8=chebpol_2(ord,xgrid(:,8));
Cheby_k9=chebpol_2(ord,xgrid(:,9));
Cheby_k10=chebpol_2(ord,xgrid(:,10));

Cheby_a1=chebpol_2(ord,xgrid(:,11));
Cheby_a2=chebpol_2(ord,xgrid(:,12));
Cheby_a3=chebpol_2(ord,xgrid(:,13));
Cheby_a4=chebpol_2(ord,xgrid(:,14));
Cheby_a5=chebpol_2(ord,xgrid(:,15));
Cheby_a6=chebpol_2(ord,xgrid(:,16));
Cheby_a7=chebpol_2(ord,xgrid(:,17));
Cheby_a8=chebpol_2(ord,xgrid(:,18));
Cheby_a9=chebpol_2(ord,xgrid(:,19));
Cheby_a10=chebpol_2(ord,xgrid(:,20));

% Construct state vectors from grid
k1_vec=scalup(xgrid(:,1),kmin,kmax);
k2_vec=scalup(xgrid(:,2),kmin,kmax);
k3_vec=scalup(xgrid(:,3),kmin,kmax);
k4_vec=scalup(xgrid(:,4),kmin,kmax);
k5_vec=scalup(xgrid(:,5),kmin,kmax);
k6_vec=scalup(xgrid(:,6),kmin,kmax);
k7_vec=scalup(xgrid(:,7),kmin,kmax);
k8_vec=scalup(xgrid(:,8),kmin,kmax);
k9_vec=scalup(xgrid(:,9),kmin,kmax);
k10_vec=scalup(xgrid(:,10),kmin,kmax);
K_vec=k1_vec+k2_vec+k3_vec+k4_vec+k5_vec+k6_vec+k7_vec+k8_vec+k9_vec+k10_vec;

a1_vec=scalup(xgrid(:,11),amin,amax);
a2_vec=scalup(xgrid(:,12),amin,amax);
a3_vec=scalup(xgrid(:,13),amin,amax);
a4_vec=scalup(xgrid(:,14),amin,amax);
a5_vec=scalup(xgrid(:,15),amin,amax);
a6_vec=scalup(xgrid(:,16),amin,amax);
a7_vec=scalup(xgrid(:,17),amin,amax);
a8_vec=scalup(xgrid(:,18),amin,amax);
a9_vec=scalup(xgrid(:,19),amin,amax);
a10_vec=scalup(xgrid(:,20),amin,amax);

% Repeat the state vectors 22 times
k1_mat=kron(ones(22,1),k1_vec);
k2_mat=kron(ones(22,1),k2_vec);
k3_mat=kron(ones(22,1),k3_vec);
k4_mat=kron(ones(22,1),k4_vec);
k5_mat=kron(ones(22,1),k5_vec);
k6_mat=kron(ones(22,1),k6_vec);
k7_mat=kron(ones(22,1),k7_vec);
k8_mat=kron(ones(22,1),k8_vec);
k9_mat=kron(ones(22,1),k9_vec);
k10_mat=kron(ones(22,1),k10_vec);
K_mat=kron(ones(22,1),K_vec);

a1_mat=kron(ones(22,1),a1_vec);
a2_mat=kron(ones(22,1),a2_vec);
a3_mat=kron(ones(22,1),a3_vec);
a4_mat=kron(ones(22,1),a4_vec);
a5_mat=kron(ones(22,1),a5_vec);
a6_mat=kron(ones(22,1),a6_vec);
a7_mat=kron(ones(22,1),a7_vec);
a8_mat=kron(ones(22,1),a8_vec);
a9_mat=kron(ones(22,1),a9_vec);
a10_mat=kron(ones(22,1),a10_vec);

% Construct regressor matrix to be used for perturbation initialization
INIT_REG=[log(k1_vec)-log(kss) log(k2_vec)-log(kss) log(k3_vec)-log(kss) log(k4_vec)-log(kss) log(k5_vec)-log(kss) log(k6_vec)-log(kss) ...
    log(k7_vec)-log(kss) log(k8_vec)-log(kss) log(k9_vec)-log(kss) log(k10_vec)-log(kss) ...
    log(a1_vec)-log(ass) log(a2_vec)-log(ass) log(a3_vec)-log(ass) log(a4_vec)-log(ass) log(a5_vec)-log(ass) log(a6_vec)-log(ass) ...
    log(a7_vec)-log(ass) log(a8_vec)-log(ass) log(a9_vec)-log(ass) log(a10_vec)-log(ass)];

% Construct next period's capital stocks and current consumption
lnkp1_vec=log(kss)+INIT_REG*hx(1,:)';
lnkp2_vec=log(kss)+INIT_REG*hx(2,:)';
lnkp3_vec=log(kss)+INIT_REG*hx(3,:)';
lnkp4_vec=log(kss)+INIT_REG*hx(4,:)';
lnkp5_vec=log(kss)+INIT_REG*hx(5,:)';
lnkp6_vec=log(kss)+INIT_REG*hx(6,:)';
lnkp7_vec=log(kss)+INIT_REG*hx(7,:)';
lnkp8_vec=log(kss)+INIT_REG*hx(8,:)';
lnkp9_vec=log(kss)+INIT_REG*hx(9,:)';
lnkp10_vec=log(kss)+INIT_REG*hx(10,:)';

if approx==2; 
for i=1:size(INIT_REG,1);  
    lnkp1_vec(i,1)=lnkp1_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(1,:,:))*INIT_REG(i,:)'+HSS(1)];
    lnkp2_vec(i,1)=lnkp2_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(2,:,:))*INIT_REG(i,:)'+HSS(2)];
    lnkp3_vec(i,1)=lnkp3_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(3,:,:))*INIT_REG(i,:)'+HSS(3)];
    lnkp4_vec(i,1)=lnkp4_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(4,:,:))*INIT_REG(i,:)'+HSS(4)];
    lnkp5_vec(i,1)=lnkp5_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(5,:,:))*INIT_REG(i,:)'+HSS(5)];
    lnkp6_vec(i,1)=lnkp6_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(6,:,:))*INIT_REG(i,:)'+HSS(6)];
    lnkp7_vec(i,1)=lnkp7_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(7,:,:))*INIT_REG(i,:)'+HSS(7)];
    lnkp8_vec(i,1)=lnkp8_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(8,:,:))*INIT_REG(i,:)'+HSS(8)];
    lnkp9_vec(i,1)=lnkp9_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(9,:,:))*INIT_REG(i,:)'+HSS(9)];
    lnkp10_vec(i,1)=lnkp10_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(10,:,:))*INIT_REG(i,:)'+HSS(10)];end
end


% Compute initial guess for coefficient vectors by OLS
REG=makepoly_2_20(Cheby_k1,Cheby_k2,Cheby_k3,Cheby_k4,Cheby_k5,Cheby_k6,Cheby_k7,Cheby_k8,Cheby_k9,Cheby_k10,...
    Cheby_a1,Cheby_a2,Cheby_a3,Cheby_a4,Cheby_a5,Cheby_a6,Cheby_a7,Cheby_a8,Cheby_a9,Cheby_a10);

dr_k1_coeff0=inv(REG'*REG)*REG'*exp(lnkp1_vec);
dr_k2_coeff0=inv(REG'*REG)*REG'*exp(lnkp2_vec);
dr_k3_coeff0=inv(REG'*REG)*REG'*exp(lnkp3_vec);
dr_k4_coeff0=inv(REG'*REG)*REG'*exp(lnkp4_vec);
dr_k5_coeff0=inv(REG'*REG)*REG'*exp(lnkp5_vec);
dr_k6_coeff0=inv(REG'*REG)*REG'*exp(lnkp6_vec);
dr_k7_coeff0=inv(REG'*REG)*REG'*exp(lnkp7_vec);
dr_k8_coeff0=inv(REG'*REG)*REG'*exp(lnkp8_vec);
dr_k9_coeff0=inv(REG'*REG)*REG'*exp(lnkp9_vec);
dr_k10_coeff0=inv(REG'*REG)*REG'*exp(lnkp10_vec);

dr_coeff0=[dr_k1_coeff0;dr_k2_coeff0;dr_k3_coeff0;...
    dr_k4_coeff0;dr_k5_coeff0;dr_k6_coeff0;dr_k7_coeff0;dr_k8_coeff0;dr_k9_coeff0;dr_k10_coeff0];


% Construct nodes to evaluate expectations in projection conditions
nodes=[zeros(22,11)];
nodes(1,1)=sqrt(2)*sqrt(11/2);
nodes(2,1)=-sqrt(2)*sqrt(11/2);
nodes(3,2)=sqrt(2)*sqrt(11/2);
nodes(4,2)=-sqrt(2)*sqrt(11/2);
nodes(5,3)=sqrt(2)*sqrt(11/2);
nodes(6,3)=-sqrt(2)*sqrt(11/2);
nodes(7,4)=sqrt(2)*sqrt(11/2);
nodes(8,4)=-sqrt(2)*sqrt(11/2);
nodes(9,5)=sqrt(2)*sqrt(11/2);
nodes(10,5)=-sqrt(2)*sqrt(11/2);
nodes(11,6)=sqrt(2)*sqrt(11/2);
nodes(12,6)=-sqrt(2)*sqrt(11/2);
nodes(13,7)=sqrt(2)*sqrt(11/2);
nodes(14,7)=-sqrt(2)*sqrt(11/2);
nodes(15,8)=sqrt(2)*sqrt(11/2);
nodes(16,8)=-sqrt(2)*sqrt(11/2);
nodes(17,9)=sqrt(2)*sqrt(11/2);
nodes(18,9)=-sqrt(2)*sqrt(11/2);
nodes(19,10)=sqrt(2)*sqrt(11/2);
nodes(20,10)=-sqrt(2)*sqrt(11/2);
nodes(21,11)=sqrt(2)*sqrt(11/2);
nodes(22,11)=-sqrt(2)*sqrt(11/2);

% Compute initial guess for coefficient vectors by OLS

% Repeat the period t regressors (N+1)*2 times
REG_mat=kron(ones(22,1),REG);

% Construct matrices for next periods exogenous states (outside loop saves
% time)
lnap1_mat=kron(ones(22,1),rho*log(a1_vec))+sigma*kron(nodes*[1;1;0;0;0;0;0;0;0;0;0],ones(size(REG,1),1));
lnap2_mat=kron(ones(22,1),rho*log(a2_vec))+sigma*kron(nodes*[1;0;1;0;0;0;0;0;0;0;0],ones(size(REG,1),1));
lnap3_mat=kron(ones(22,1),rho*log(a3_vec))+sigma*kron(nodes*[1;0;0;1;0;0;0;0;0;0;0],ones(size(REG,1),1));
lnap4_mat=kron(ones(22,1),rho*log(a4_vec))+sigma*kron(nodes*[1;0;0;0;1;0;0;0;0;0;0],ones(size(REG,1),1));
lnap5_mat=kron(ones(22,1),rho*log(a5_vec))+sigma*kron(nodes*[1;0;0;0;0;1;0;0;0;0;0],ones(size(REG,1),1));
lnap6_mat=kron(ones(22,1),rho*log(a6_vec))+sigma*kron(nodes*[1;0;0;0;0;0;1;0;0;0;0],ones(size(REG,1),1));
lnap7_mat=kron(ones(22,1),rho*log(a7_vec))+sigma*kron(nodes*[1;0;0;0;0;0;0;1;0;0;0],ones(size(REG,1),1));
lnap8_mat=kron(ones(22,1),rho*log(a8_vec))+sigma*kron(nodes*[1;0;0;0;0;0;0;0;1;0;0],ones(size(REG,1),1));
lnap9_mat=kron(ones(22,1),rho*log(a9_vec))+sigma*kron(nodes*[1;0;0;0;0;0;0;0;0;1;0],ones(size(REG,1),1));
lnap10_mat=kron(ones(22,1),rho*log(a10_vec))+sigma*kron(nodes*[1;0;0;0;0;0;0;0;0;0;1],ones(size(REG,1),1));

ap1_mat=exp(lnap1_mat);
ap2_mat=exp(lnap2_mat);
ap3_mat=exp(lnap3_mat);
ap4_mat=exp(lnap4_mat);
ap5_mat=exp(lnap5_mat);
ap6_mat=exp(lnap6_mat);
ap7_mat=exp(lnap7_mat);
ap8_mat=exp(lnap8_mat);
ap9_mat=exp(lnap9_mat);
ap10_mat=exp(lnap10_mat);

cheby_ap1_mat=chebpol_2(ord,scaldown(exp(lnap1_mat),amin,amax));
cheby_ap2_mat=chebpol_2(ord,scaldown(exp(lnap2_mat),amin,amax));
cheby_ap3_mat=chebpol_2(ord,scaldown(exp(lnap3_mat),amin,amax));
cheby_ap4_mat=chebpol_2(ord,scaldown(exp(lnap4_mat),amin,amax));
cheby_ap5_mat=chebpol_2(ord,scaldown(exp(lnap5_mat),amin,amax));
cheby_ap6_mat=chebpol_2(ord,scaldown(exp(lnap6_mat),amin,amax));
cheby_ap7_mat=chebpol_2(ord,scaldown(exp(lnap7_mat),amin,amax));
cheby_ap8_mat=chebpol_2(ord,scaldown(exp(lnap8_mat),amin,amax));
cheby_ap9_mat=chebpol_2(ord,scaldown(exp(lnap9_mat),amin,amax));
cheby_ap10_mat=chebpol_2(ord,scaldown(exp(lnap10_mat),amin,amax));

% compute output levels
y1_mat=A.*a1_mat.*k1_mat.^alpha;
y2_mat=A.*a2_mat.*k2_mat.^alpha;
y3_mat=A.*a3_mat.*k3_mat.^alpha;
y4_mat=A.*a4_mat.*k4_mat.^alpha;
y5_mat=A.*a5_mat.*k5_mat.^alpha;
y6_mat=A.*a6_mat.*k6_mat.^alpha;
y7_mat=A.*a7_mat.*k7_mat.^alpha;
y8_mat=A.*a8_mat.*k8_mat.^alpha;
y9_mat=A.*a9_mat.*k9_mat.^alpha;
y10_mat=A.*a10_mat.*k10_mat.^alpha;
Y_mat=y1_mat+y2_mat+y3_mat+y4_mat+y5_mat+y6_mat+y7_mat+y8_mat+y9_mat+y10_mat;

% Derive the nonlinear relation between C and c1
build_c_grid

dr_coeff=dr_coeff0;

dr_coeff=fcsolve('projections_res',dr_coeff,[10000;1e-3;1e-8;1e-3;1]);

dr_coeff_A1N10=dr_coeff;
cpu1=cputime;
Time_Sol=cpu1-cpu0;

save('WSP_SOLUTION_A1_N10');
save PI_A1N10.mat dr_coeff_A1N10 kmin kmax amin amax C_min C_max regvec
