% Main file to solve model A5 with N=4

clear all

cpu0=cputime;

global N beta alpha delta sigma rho phi A gamma tau ord
global kmin kmax amin amax
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat k3_mat k4_mat  K_mat
global a1_mat a2_mat a3_mat a4_mat 
global ap1_mat ap2_mat ap3_mat ap4_mat 
global y1_mat y2_mat y3_mat y4_mat Y_mat
global cheby_ap1_mat cheby_ap2_mat cheby_ap3_mat
global cheby_ap4_mat 
global regvec C_min C_max

%%%%%%%%%%%%%%%%%%%%%%
% 1. Getting started %
%%%%%%%%%%%%%%%%%%%%%%

approx=1;   % set order of approximation for perturbation solution (initilization)
ord=2;      % set order of approximation for monomial Galerkin method

kmin=0.95;  % Set bounds for the state space
kmax=1.05;
amin=exp(-0.05);
amax=exp(+0.05);


% 1) Calibration
N=4;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);
gammalow=0.25;
gammahigh=1;
gamma=[gammalow:(gammahigh-gammalow)/(N-1):gammahigh];

% 2) Compute the steady state and the Negishi weights
kss=1;
Kss=N*kss;
css=A*kss^alpha;
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=N*A*kss^alpha;


% 3) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=css^(1/gamma(j));
end
muss=1;


% 4) Compute the steady state in logs
lnkss=log(kss);
lnKss=log(Kss);
lncss=log(css);
lnCss=log(Css);
lnthetass=log(thetass);
lnYss=log(Yss);
lnmuss=log(muss);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. Construct first-order approximation using method by Klein (2000)  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Define symbolic variables
syms c1 lna1 k1 theta1 cp1 lnap1 kp1 thetap1
syms c2 lna2 k2 theta2 cp2 lnap2 kp2 thetap2
syms c3 lna3 k3 theta3 cp3 lnap3 kp3 thetap3
syms c4 lna4 k4 theta4 cp4 lnap4 kp4 thetap4
syms C Cp K Kp Y Yp CAC CACp mu mup

% 1) Define symbolic variables
syms lnc1 lna1 lnk1 lntheta1 lncp1 lnap1 lnkp1 lnthetap1
syms lnc2 lna2 lnk2 lntheta2 lncp2 lnap2 lnkp2 lnthetap2
syms lnc3 lna3 lnk3 lntheta3 lncp3 lnap3 lnkp3 lnthetap3
syms lnc4 lna4 lnk4 lntheta4 lncp4 lnap4 lnkp4 lnthetap4
syms lnC lnCp lnK lnKp lnY lnYp CAC CACp lnmu lnmup

% 2) Construct the system of equilibrium conditions

f1=exp(lnc1)^(-1/gamma(1))*[1+phi*(exp(lnkp1)/exp(lnk1)-1)]-beta*exp(lncp1)^(-1/gamma(1))*[exp(lnthetap1)+exp(lnap1)*A*alpha*exp(lnkp1)^(alpha-1)];
f2=exp(lntheta1)-[1+phi*[1+0.5*(exp(lnkp1)/exp(lnk1)-1)]*(exp(lnkp1)/exp(lnk1)-1)];
f3=tau(1)*exp(lnc1)^(-1/gamma(1))-exp(lnmu);
f4=lnap1-rho*lna1;

f5=exp(lnc2)^(-1/gamma(2))*[1+phi*(exp(lnkp2)/exp(lnk2)-1)]-beta*exp(lncp2)^(-1/gamma(2))*[exp(lnthetap2)+exp(lnap2)*A*alpha*exp(lnkp2)^(alpha-1)];
f6=exp(lntheta2)-[1+phi*[1+0.5*(exp(lnkp2)/exp(lnk2)-1)]*(exp(lnkp2)/exp(lnk2)-1)];
f7=tau(2)*exp(lnc2)^(-1/gamma(2))-exp(lnmu);
f8=lnap2-rho*lna2;

f9=exp(lnc3)^(-1/gamma(3))*[1+phi*(exp(lnkp3)/exp(lnk3)-1)]-beta*exp(lncp3)^(-1/gamma(3))*[exp(lnthetap3)+exp(lnap3)*A*alpha*exp(lnkp3)^(alpha-1)];
f10=exp(lntheta3)-[1+phi*[1+0.5*(exp(lnkp3)/exp(lnk3)-1)]*(exp(lnkp3)/exp(lnk3)-1)];
f11=tau(3)*exp(lnc3)^(-1/gamma(3))-exp(lnmu);
f12=lnap3-rho*lna3;

f13=exp(lnc4)^(-1/gamma(4))*[1+phi*(exp(lnkp4)/exp(lnk4)-1)]-beta*exp(lncp4)^(-1/gamma(4))*[exp(lnthetap4)+exp(lnap4)*A*alpha*exp(lnkp4)^(alpha-1)];
f14=exp(lntheta4)-[1+phi*[1+0.5*(exp(lnkp4)/exp(lnk4)-1)]*(exp(lnkp4)/exp(lnk4)-1)];
f15=tau(4)*exp(lnc4)^(-1/gamma(4))-exp(lnmu);
f16=lnap4-rho*lna4;

f17=exp(lnc1)+exp(lnc2)+exp(lnc3)+exp(lnc4)-exp(lnC);
f18=exp(lnk1)+exp(lnk2)+exp(lnk3)+exp(lnk4)-exp(lnK);
f19=exp(lna1)*A*exp(lnk1)^alpha+exp(lna2)*A*exp(lnk2)^alpha+exp(lna3)*A*exp(lnk3)^alpha+exp(lna4)*A*exp(lnk4)^alpha-exp(lnY);
f20=exp(lnC)+exp(lnKp)-exp(lnK)-exp(lnY)+...
    phi/2*[exp(lnk1)*(exp(lnkp1)/exp(lnk1)-1)^2+exp(lnk2)*(exp(lnkp2)/exp(lnk2)-1)^2+exp(lnk3)*(exp(lnkp3)/exp(lnk3)-1)^2+exp(lnk4)*(exp(lnkp4)/exp(lnk4)-1)^2];

f=[f1;f2;f3;f4;f5;f6;f7;f8;f9;f10;f11;f12;f13;f14;f15;f16;f17;f18;f19;f20];

% 3) Define vectors of states and controls
xx=[lnk1 lnk2 lnk3 lnk4 lna1 lna2 lna3 lna4];
xxp=[lnkp1 lnkp2 lnkp3 lnkp4 lnap1 lnap2 lnap3 lnap4];

yy=[lnc1 lnc2 lnc3 lnc4  lntheta1 lntheta2 lntheta3 lntheta4 lnmu lnC lnK lnY];
yyp=[lncp1 lncp2 lncp3 lncp4 lnthetap1 lnthetap2 lnthetap3 lnthetap4 lnmup lnCp lnKp lnYp];

% 4) Compute analytical derivatives and evaluate them at the steady state
nx = length(xx);
ny = length(yy);

[fx,fxp,fy,fyp,fypyp,fypy,fypxp,fypx,fyyp,fyy,fyxp,fyx,fxpyp,fxpy,...
    fxpxp,fxpx,fxyp,fxy,fxxp,fxx]=anal_deriv(f,xx,yy,xxp,yyp);

assign_steadystate;
num_eval;

% 5) Construct log-linear approximation using the Klein (2000) algorithm
[gx,hx] = gx_hx(nfy,nfx,nfyp,nfxp);

% 6) Construct log-quadratic approximation: Schmitt-Grohe and Uribe (2004)
if approx==2; 
etamat=zeros(nx,N+1);
for jj=1:N
    etamat(nx/2+jj,1)=sigma;
    etamat(nx/2+jj,1+jj)=sigma;
end
[GXX,HXX] = gxx_hxx(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx);
[GSS,HSS] = gss_hss(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx,GXX,etamat);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3. Construct initial guess for decision rule coefficients %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 2) Construct monomial grid (Integration formula Cn:5.2 in Stroud (1971))
nx=8;
r_Mon=sqrt(3/5);
V_MON=2^nx;
B0_MON=(25*nx^2-115*nx+162)/162*V_MON;
B1_MON=(70-25*nx)/162*V_MON;
B2_MON=25/324*V_MON;

% build grid	
xgrid=zeros(2*nx^2+1,nx);
for j=1:nx
xgrid(2*j,j)=r_Mon;
xgrid(2*j+1,j)=-r_Mon;
end

ind=1+2*nx+1;
interim=[r_Mon r_Mon;r_Mon -r_Mon;-r_Mon r_Mon;-r_Mon -r_Mon];

for j=1:(nx-1)
    for i=j+1:nx
        xgrid(ind:ind+3,j)=interim(:,1);
        xgrid(ind:ind+3,i)=interim(:,2);
        ind=ind+4;
    end
end

% Construct Chebyshev polynomials from grid
Cheby_k1=chebpol_2(ord,xgrid(:,1));
Cheby_k2=chebpol_2(ord,xgrid(:,2));
Cheby_k3=chebpol_2(ord,xgrid(:,3));
Cheby_k4=chebpol_2(ord,xgrid(:,4));

Cheby_a1=chebpol_2(ord,xgrid(:,5));
Cheby_a2=chebpol_2(ord,xgrid(:,6));
Cheby_a3=chebpol_2(ord,xgrid(:,7));
Cheby_a4=chebpol_2(ord,xgrid(:,8));


% Construct state vectors from grid
k1_vec=scalup(xgrid(:,1),kmin,kmax);
k2_vec=scalup(xgrid(:,2),kmin,kmax);
k3_vec=scalup(xgrid(:,3),kmin,kmax);
k4_vec=scalup(xgrid(:,4),kmin,kmax);

K_vec=k1_vec+k2_vec+k3_vec+k4_vec;

a1_vec=scalup(xgrid(:,5),amin,amax);
a2_vec=scalup(xgrid(:,6),amin,amax);
a3_vec=scalup(xgrid(:,7),amin,amax);
a4_vec=scalup(xgrid(:,8),amin,amax);


% Repeat the state vectors 10 times
k1_mat=kron(ones(10,1),k1_vec);
k2_mat=kron(ones(10,1),k2_vec);
k3_mat=kron(ones(10,1),k3_vec);
k4_mat=kron(ones(10,1),k4_vec);
K_mat=kron(ones(10,1),K_vec);

a1_mat=kron(ones(10,1),a1_vec);
a2_mat=kron(ones(10,1),a2_vec);
a3_mat=kron(ones(10,1),a3_vec);
a4_mat=kron(ones(10,1),a4_vec);


% Construct regressor matrix to be used for perturbation initialization
INIT_REG=[log(k1_vec)-log(kss) log(k2_vec)-log(kss) log(k3_vec)-log(kss) log(k4_vec)-log(kss)  ...
    log(a1_vec)-log(ass) log(a2_vec)-log(ass) log(a3_vec)-log(ass) log(a4_vec)-log(ass)];

% Construct next period's capital stocks and current consumption
lnkp1_vec=log(kss)+INIT_REG*hx(1,:)';
lnkp2_vec=log(kss)+INIT_REG*hx(2,:)';
lnkp3_vec=log(kss)+INIT_REG*hx(3,:)';
lnkp4_vec=log(kss)+INIT_REG*hx(4,:)';


if approx==2; 
for i=1:size(INIT_REG,1);  
    lnkp1_vec(i,1)=lnkp1_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(1,:,:))*INIT_REG(i,:)'+HSS(1)];
    lnkp2_vec(i,1)=lnkp2_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(2,:,:))*INIT_REG(i,:)'+HSS(2)];
    lnkp3_vec(i,1)=lnkp3_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(3,:,:))*INIT_REG(i,:)'+HSS(3)];
    lnkp4_vec(i,1)=lnkp4_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(4,:,:))*INIT_REG(i,:)'+HSS(4)];
end
end


% Compute initial guess for coefficient vectors by OLS
REG=makepoly_2_8(Cheby_k1,Cheby_k2,Cheby_k3,Cheby_k4,...
    Cheby_a1,Cheby_a2,Cheby_a3,Cheby_a4);

dr_k1_coeff0=inv(REG'*REG)*REG'*exp(lnkp1_vec);
dr_k2_coeff0=inv(REG'*REG)*REG'*exp(lnkp2_vec);
dr_k3_coeff0=inv(REG'*REG)*REG'*exp(lnkp3_vec);
dr_k4_coeff0=inv(REG'*REG)*REG'*exp(lnkp4_vec);

dr_coeff0=[dr_k1_coeff0;dr_k2_coeff0;dr_k3_coeff0;dr_k4_coeff0];


% Construct nodes to evaluate expectations in projection conditions
nodes=[zeros(10,5)];
nodes(1,1)=sqrt(2)*sqrt(5/2);
nodes(2,1)=-sqrt(2)*sqrt(5/2);
nodes(3,2)=sqrt(2)*sqrt(5/2);
nodes(4,2)=-sqrt(2)*sqrt(5/2);
nodes(5,3)=sqrt(2)*sqrt(5/2);
nodes(6,3)=-sqrt(2)*sqrt(5/2);
nodes(7,4)=sqrt(2)*sqrt(5/2);
nodes(8,4)=-sqrt(2)*sqrt(5/2);
nodes(9,5)=sqrt(2)*sqrt(5/2);
nodes(10,5)=-sqrt(2)*sqrt(5/2);


% Repeat the period t regressors (N+1)*2 times
REG_mat=kron(ones(10,1),REG);

% Construct matrices for next periods exogenous states (outside loop saves
% time)
lnap1_mat=kron(ones(10,1),rho*log(a1_vec))+sigma*kron(nodes*[1;1;0;0;0],ones(size(REG,1),1));
lnap2_mat=kron(ones(10,1),rho*log(a2_vec))+sigma*kron(nodes*[1;0;1;0;0],ones(size(REG,1),1));
lnap3_mat=kron(ones(10,1),rho*log(a3_vec))+sigma*kron(nodes*[1;0;0;1;0],ones(size(REG,1),1));
lnap4_mat=kron(ones(10,1),rho*log(a4_vec))+sigma*kron(nodes*[1;0;0;0;1],ones(size(REG,1),1));

ap1_mat=exp(lnap1_mat);
ap2_mat=exp(lnap2_mat);
ap3_mat=exp(lnap3_mat);
ap4_mat=exp(lnap4_mat);


cheby_ap1_mat=chebpol_2(ord,scaldown(exp(lnap1_mat),amin,amax));
cheby_ap2_mat=chebpol_2(ord,scaldown(exp(lnap2_mat),amin,amax));
cheby_ap3_mat=chebpol_2(ord,scaldown(exp(lnap3_mat),amin,amax));
cheby_ap4_mat=chebpol_2(ord,scaldown(exp(lnap4_mat),amin,amax));

% compute output levels
y1_mat=A.*a1_mat.*k1_mat.^alpha;
y2_mat=A.*a2_mat.*k2_mat.^alpha;
y3_mat=A.*a3_mat.*k3_mat.^alpha;
y4_mat=A.*a4_mat.*k4_mat.^alpha;
Y_mat=y1_mat+y2_mat+y3_mat+y4_mat;

% Derive the nonlinear relation between C and c1
build_c_grid
dr_coeff=dr_coeff0;


dr_coeff=fcsolve('projections_res',dr_coeff,[10000;1e-6;1e-4;1e-3;1]);
dr_coeff_A5N4=dr_coeff;
cpu1=cputime;
Time_Sol=cpu1-cpu0;

save('WSP_SOLUTION_A5_N4');

save PI_A5N4.mat dr_coeff_A5N4 kmin kmax amin amax C_min C_max regvec
