% Main file to solve model A6 with N=2

clear all

cpu0=cputime;

global N beta alpha delta sigma rho phi A gamma tau ord eta b
global kmin kmax amin amax
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat  K_mat
global a1_mat a2_mat 
global ap1_mat ap2_mat a
global y1_mat y2_mat Y_mat
global cheby_ap1_mat cheby_ap2_mat
global regvec C_min C_max
global weights_vec

%%%%%%%%%%%%%%%%%%%%%%
% 1. Getting started %
%%%%%%%%%%%%%%%%%%%%%%

approx=1;   % set order of approximation for perturbation solution (initilization)
ord=2;      % set order of approximation for monomial Galerkin method

kmin=0.9;  % Set bounds for the state space
kmax=1.1;
amin=exp(-0.1);
amax=exp(+0.1);

% 1) Calibration
N=2;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);
gammalow=0.25;
gammahigh=1;
gamma=[gammalow:(gammahigh-gammalow)/(N-1):gammahigh];
etalow=0.1;
etahigh=1;
eta=-[etalow:(etahigh-etalow)/(N-1):etahigh];

% 2) Compute the steady state, the Negishi weights and the labor weight in
% the utility function

% a)
kss=1;
lss=1;
Kss=N*kss;
Lss=N*lss;
css=A*kss^alpha;
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=A*Kss^alpha*Lss^(1-alpha);


% b) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=css^(1/gamma(j));
end
muss=1;

% c) Labor weights
b=zeros(1,N);
for j=1:N
    b(j)=(1-alpha)*A^(1-1/gamma(j));
end



% 4) Compute the steady state in logs
lnkss=log(kss);
lnKss=log(Kss);
lncss=log(css);
lnCss=log(Css);
lnthetass=log(thetass);
lnYss=log(Yss);
lnLss=log(Lss);
lnlss=log(lss);
lnmuss=log(muss);

% 5) Compute the nonlinear relation between C and c1
build_c_grid


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. Construct first-order approximation using method by Klein (2000)  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Define symbolic variables
syms c1 lna1 k1 theta1 cp1 lnap1 kp1 thetap1 l1 lp1
syms c2 lna2 k2 theta2 cp2 lnap2 kp2 thetap2 l2 lp2
syms C Cp K Kp Y Yp CAC CACp mu mup L Lp

% 1) Define symbolic variables
syms lnc1 lna1 lnk1 lntheta1 lncp1 lnap1 lnkp1 lnthetap1 lnl1 lnlp1
syms lnc2 lna2 lnk2 lntheta2 lncp2 lnap2 lnkp2 lnthetap2 lnl2 lnlp2
syms lnC lnCp lnK lnKp lnY lnYp CAC CACp lnmu lnmup lnL lnLp

% 2) Construct the system of equilibrium conditions

f1=exp(lnc1)^(-1/gamma(1))*[1+phi*(exp(lnkp1)/exp(lnk1)-1)]-beta*exp(lncp1)^(-1/gamma(1))*[exp(lnthetap1)+exp(lnap1)*A*alpha*exp(lnkp1)^(alpha-1)*exp(lnlp1)^(1-alpha)];
f1b=b(1)*[exp(lnl1)^(alpha-1/eta(1))]-[exp(lnc1)^(-1/gamma(1))]*exp(lna1)*(1-alpha)*A*exp(lnk1)^alpha;
f2=exp(lntheta1)-[1+phi*[1+0.5*(exp(lnkp1)/exp(lnk1)-1)]*(exp(lnkp1)/exp(lnk1)-1)];
f3=tau(1)*exp(lnc1)^(-1/gamma(1))-exp(lnmu);
f4=lnap1-rho*lna1;

f5=exp(lnc2)^(-1/gamma(2))*[1+phi*(exp(lnkp2)/exp(lnk2)-1)]-beta*exp(lncp2)^(-1/gamma(2))*[exp(lnthetap2)+exp(lnap2)*A*alpha*exp(lnkp2)^(alpha-1)*exp(lnlp2)^(1-alpha)];
f5b=b(2)*[exp(lnl2)^(alpha-1/eta(2))]-[exp(lnc2)^(-1/gamma(2))]*exp(lna2)*(1-alpha)*A*exp(lnk2)^alpha;
f6=exp(lntheta2)-[1+phi*[1+0.5*(exp(lnkp2)/exp(lnk2)-1)]*(exp(lnkp2)/exp(lnk2)-1)];
f7=tau(2)*exp(lnc2)^(-1/gamma(2))-exp(lnmu);
f8=lnap2-rho*lna2;


f25=exp(lnc1)+exp(lnc2)-exp(lnC);
f26=exp(lnk1)+exp(lnk2)-exp(lnK);
f27=exp(lna1)*A*exp(lnk1)^alpha*exp(lnl1)^(1-alpha)+exp(lna2)*A*exp(lnk2)^alpha*exp(lnl2)^(1-alpha)-exp(lnY);
f28=exp(lnC)+exp(lnKp)-exp(lnK)-exp(lnY)+...
    phi/2*[exp(lnk1)*(exp(lnkp1)/exp(lnk1)-1)^2+exp(lnk2)*(exp(lnkp2)/exp(lnk2)-1)^2];

f=[f1;f1b;f2;f3;f4;f5;f5b;f6;f7;f8;f25;f26;f27;f28];

% 3) Define vectors of states and controls
xx=[lnk1 lnk2 lna1 lna2];
xxp=[lnkp1 lnkp2 lnap1 lnap2];

yy=[lnc1 lnc2 lntheta1 lntheta2 lnmu lnC lnK lnY lnl1 lnl2];
yyp=[lncp1 lncp2 lnthetap1 lnthetap2 lnmup lnCp lnKp lnYp lnlp1 lnlp2];

% 4) Compute analytical derivatives and evaluate them at the steady state
nx = length(xx);
ny = length(yy);

[fx,fxp,fy,fyp,fypyp,fypy,fypxp,fypx,fyyp,fyy,fyxp,fyx,fxpyp,fxpy,...
    fxpxp,fxpx,fxyp,fxy,fxxp,fxx]=anal_deriv(f,xx,yy,xxp,yyp);

assign_steadystate;
num_eval;

% 5) Construct log-linear approximation using the Klein (2000) algorithm
[gx,hx] = gx_hx(nfy,nfx,nfyp,nfxp);

if approx==2; 
etamat=zeros(nx,N+1);
for jj=1:N
    etamat(nx/2+jj,1)=sigma;
    etamat(nx/2+jj,1+jj)=sigma;
end
[GXX,HXX] = gxx_hxx_sparse(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx);
[GSS,HSS] = gss_hss(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx,GXX,etamat);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3. Construct initial guess for decision rule coefficients %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 2) Construct monomial grid (Integration formula Cn:5.2 in Stroud (1971))
nx=2*N;
r_Mon=sqrt(3/5);
V_MON=2^nx;
B0_MON=(25*nx^2-115*nx+162)/162*V_MON;
B1_MON=(70-25*nx)/162*V_MON;
B2_MON=25/324*V_MON;

% build grid	
xgrid=zeros(2*nx^2+1,nx);
for j=1:nx
xgrid(2*j,j)=r_Mon;
xgrid(2*j+1,j)=-r_Mon;
end

ind=1+2*nx+1;
interim=[r_Mon r_Mon;r_Mon -r_Mon;-r_Mon r_Mon;-r_Mon -r_Mon];

for j=1:(nx-1)
    for i=j+1:nx
        xgrid(ind:ind+3,j)=interim(:,1);
        xgrid(ind:ind+3,i)=interim(:,2);
        ind=ind+4;
    end
end

% Construct Chebyshev polynomials from grid
Cheby_k1=chebpol_2(ord,xgrid(:,1));
Cheby_k2=chebpol_2(ord,xgrid(:,2));

Cheby_a1=chebpol_2(ord,xgrid(:,3));
Cheby_a2=chebpol_2(ord,xgrid(:,4));


% Construct state vectors from grid
k1_vec=scalup(xgrid(:,1),kmin,kmax);
k2_vec=scalup(xgrid(:,2),kmin,kmax);
K_vec=k1_vec+k2_vec;

a1_vec=scalup(xgrid(:,3),amin,amax);
a2_vec=scalup(xgrid(:,4),amin,amax);

% Compute nodes to compute expectations
nshocks=N+1;
expect_r=sqrt((nshocks+2)/2);
expect_s=sqrt((nshocks+2)/4);
expect_V=3.14159265358979^(nshocks/2);
expect_A=2/(nshocks+2)*expect_V;
expect_B=(4-nshocks)/[2*(nshocks+2)^2]*expect_V;
expect_C=1/[(nshocks+2)^2]*expect_V;

nodes=zeros(2*nshocks^2+1,nshocks);

for j=1:nshocks
    nodes(2*j,j)=expect_r;
    nodes(2*j+1,j)=-expect_r;
end

ind=1+2*nshocks+1;
interim=[expect_s expect_s;expect_s -expect_s;-expect_s expect_s;-expect_s -expect_s];

for j=1:(nshocks-1)
    for i=j+1:nshocks
        nodes(ind:ind+3,j)=interim(:,1);
        nodes(ind:ind+3,i)=interim(:,2);
        ind=ind+4;
    end
end

nodes=nodes.*sqrt(2);

len_nodes=2*nshocks^2+1;
ones_nod=ones(len_nodes,1);

weights_vec=expect_V^(-1)*[expect_A;ones(nshocks*2,1)*expect_B;ones(length(nodes)-2*nshocks-1,1)*expect_C];


% Repeat the state vectors 14 times
k1_mat=kron(ones(len_nodes,1),k1_vec);
k2_mat=kron(ones(len_nodes,1),k2_vec);
K_mat=kron(ones(len_nodes,1),K_vec);

a1_mat=kron(ones(len_nodes,1),a1_vec);
a2_mat=kron(ones(len_nodes,1),a2_vec);

% Construct regressor matrix to be used for perturbation initialization
INIT_REG=[log(k1_vec)-log(kss) log(k2_vec)-log(kss) log(a1_vec)-log(ass) log(a2_vec)-log(ass)];

% Construct next period's capital stocks and current consumption
lnkp1_vec=log(kss)+INIT_REG*hx(1,:)';
lnkp2_vec=log(kss)+INIT_REG*hx(2,:)';
lnC_vec=lnCss+INIT_REG*gx(6,:)';

if approx==2; 
for i=1:size(INIT_REG,1);  
    lnkp1_vec(i,1)=lnkp1_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(1,:,:))*INIT_REG(i,:)'+HSS(1)];
    lnkp2_vec(i,1)=lnkp2_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(2,:,:))*INIT_REG(i,:)'+HSS(2)];
    lnC_vec(i,1)=lnC_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(GXX(6,:,:))*INIT_REG(i,:)'+GSS(6)];
end
end

% Compute initial guess for coefficient vectors by OLS
REG=makepoly_2_4(Cheby_k1,Cheby_k2,Cheby_a1,Cheby_a2);

dr_k1_coeff0=inv(REG'*REG)*REG'*exp(lnkp1_vec);
dr_k2_coeff0=inv(REG'*REG)*REG'*exp(lnkp2_vec);
dr_C_coeff0=inv(REG'*REG)*REG'*exp(lnC_vec);

dr_coeff0=[dr_k1_coeff0;dr_k2_coeff0;dr_C_coeff0];

% Compute initial guess for coefficient vectors by OLS

% Repeat the period t regressors (N+1)*2 times
REG_mat=kron(ones(len_nodes,1),REG);

% Construct matrices for next periods exogenous states (outside loop saves
% time)
lnap1_mat=kron(ones(len_nodes,1),rho*log(a1_vec))+sigma*kron(nodes*[1;1;0],ones(size(REG,1),1));
lnap2_mat=kron(ones(len_nodes,1),rho*log(a2_vec))+sigma*kron(nodes*[1;0;1],ones(size(REG,1),1));

ap1_mat=exp(lnap1_mat);
ap2_mat=exp(lnap2_mat);

cheby_ap1_mat=chebpol_2(ord,scaldown(exp(lnap1_mat),amin,amax));
cheby_ap2_mat=chebpol_2(ord,scaldown(exp(lnap2_mat),amin,amax));

dr_coeff=dr_coeff0;
dr_coeff=fcsolve('projections_res',dr_coeff,[10000;1e-6;1e-8;1e-3;0]);
dr_coeff_A6N2=dr_coeff;
cpu1=cputime;
Time_Sol=cpu1-cpu0;

save('WSP_SOLUTION_A6_N2');
save PI_A6N2.mat dr_coeff_A6N2 kmin kmax amin amax C_min C_max regvec
