% Main file to solve model A8 with N=2
clear all

cpu0=cputime;

global N beta alpha delta sigma rho phi A gamma tau ord psi Le chi b mupar
global kmin kmax amin amax cmin cmax
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat k3_mat k4_mat K_mat
global a1_mat a2_mat a3_mat a4_mat 
global ap1_mat ap2_mat ap3_mat ap4_mat 
global y1_mat y2_mat y3_mat y4_mat Y_mat
global cheby_ap1_mat cheby_ap2_mat cheby_ap3_mat
global cheby_ap4_mat 
global regvec_labor1 regvec_labor2 regvec_labor3 regvec_labor4 mumin mumax mu_mat
global weights_vec len_nodes

%%%%%%%%%%%%%%%%%%%%%%
% 1. Getting started %
%%%%%%%%%%%%%%%%%%%%%%

approx=1;   % set order of approximation for perturbation solution (initilization)
ord=2;      % set order of approximation for monomial Galerkin method
kmin=0.8;  % Set bounds for the state space
kmax=1.2;
amin=exp(-0.16);
amax=exp(+0.16);

% 1) Calibration
N=2;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);
gammalow=0.2;
gammahigh=0.4;
gamma=[gammalow:(gammahigh-gammalow)/(N-1):gammahigh];
chilow=0.75;
chihigh=0.9;
chi=[chilow:(chihigh-chilow)/(N-1):chihigh];
muparlow=-0.3;
muparhigh=0.3;
mupar=[muparlow:(muparhigh-muparlow)/(N-1):muparhigh];
Le=2.5;


% 2) Compute the steady state, the Negishi weights and the labor weight in
% the utility function

% a)
kss=1;
lss=1;
Kss=N*kss;
Lss=N*lss;
css=A*kss^alpha*lss^(1-alpha);
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=N*A;

b=zeros(1,N);
for j=1:N
    b(j)=(1-alpha)*A^(1-1/chi(j))/[(Le-lss)^(-1/chi(j))];
end


% b) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=[css^(-1/chi(j))*[css^(1-1/chi(j))+b(j)*(Le-lss)^(1-1/chi(j))]^[(1-1/gamma(j))/(1-1/chi(j))-1]]^(-1);
end
muss=1;




% 4) Compute the steady state in logs
lnkss=log(kss);
lnKss=log(Kss);
lncss=log(css);
lnCss=log(Css);
lnthetass=log(thetass);
lnYss=log(Yss);
lnLss=log(Lss);
lnlss=log(lss);
lnmuss=log(muss);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. Construct first-order approximation using method by Klein (2000)  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1) Define symbolic variables
syms c1 lna1 k1 theta1 cp1 lnap1 kp1 thetap1 l1 lp1
syms c2 lna2 k2 theta2 cp2 lnap2 kp2 thetap2 l2 lp2
syms C Cp K Kp Y Yp CAC CACp mu mup L Lp

% 1) Define symbolic variables
syms lnc1 lna1 lnk1 lntheta1 lncp1 lnap1 lnkp1 lnthetap1 lnl1 lnlp1
syms lnc2 lna2 lnk2 lntheta2 lncp2 lnap2 lnkp2 lnthetap2 lnl2 lnlp2
syms lnC lnCp lnK lnKp lnY lnYp CAC CACp lnmu lnmup lnL lnLp

% 2) Construct the system of equilibrium conditions

f1=exp(lnmu)*[1+phi*(exp(lnkp1)/exp(lnk1)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap1)+exp(lnap1)*alpha*A*...
    exp(lnkp1)^(mupar(1)-1)*[alpha*exp(lnkp1)^(mupar(1))+(1-alpha)*exp(lnlp1)^(mupar(1))]^(1/mupar(1)-1)];
f1b=b(1)*exp(lnc1)^(1/chi(1))*(Le-exp(lnl1))^(-1/chi(1))-...
    exp(lna1)*(1-alpha)*A*exp(lnl1)^(mupar(1)-1)*[alpha*exp(lnk1)^(mupar(1))+(1-alpha)*exp(lnl1)^(mupar(1))]^(1/mupar(1)-1);
f2=exp(lntheta1)-[1+phi*[1+0.5*(exp(lnkp1)/exp(lnk1)-1)]*(exp(lnkp1)/exp(lnk1)-1)];
f3=tau(1)*[exp(lnc1)^(-1/chi(1))*[exp(lnc1)^(1-1/chi(1))+b(1)*[Le-exp(lnl1)]^(1-1/chi(1))]^[(1-1/gamma(1))/(1-1/chi(1))-1]]-exp(lnmu);
f4=lnap1-rho*lna1;

f5=exp(lnmu)*[1+phi*(exp(lnkp2)/exp(lnk2)-1)]-...
    beta*exp(lnmup)*[exp(lnthetap2)+exp(lnap2)*alpha*A*...
    exp(lnkp2)^(mupar(2)-1)*[alpha*exp(lnkp2)^(mupar(2))+(1-alpha)*exp(lnlp2)^(mupar(2))]^(1/mupar(2)-1)];
f5b=b(2)*exp(lnc2)^(1/chi(2))*(Le-exp(lnl2))^(-1/chi(2))-...
    exp(lna2)*(1-alpha)*A*exp(lnl2)^(mupar(2)-1)*[alpha*exp(lnk2)^(mupar(2))+(1-alpha)*exp(lnl2)^(mupar(2))]^(1/mupar(2)-1);
f6=exp(lntheta2)-[1+phi*[1+0.5*(exp(lnkp2)/exp(lnk2)-1)]*(exp(lnkp2)/exp(lnk2)-1)];
f7=[tau(2)*exp(lnc2)^(-1/chi(2))*[exp(lnc2)^(1-1/chi(2))+b(2)*[Le-exp(lnl2)]^(1-1/chi(2))]^[(1-1/gamma(2))/(1-1/chi(2))-1]]-exp(lnmu);
f8=lnap2-rho*lna2;

f25=exp(lnc1)+exp(lnc2)-exp(lnC);
f26=exp(lnk1)+exp(lnk2)-exp(lnK);

f27=exp(lna1)*A*[alpha*exp(lnk1)^(mupar(1))+(1-alpha)*exp(lnl1)^(mupar(1))]^(1/mupar(1))+...
    exp(lna2)*A*[alpha*exp(lnk2)^(mupar(2))+(1-alpha)*exp(lnl2)^(mupar(2))]^(1/mupar(2))-exp(lnY);

f28=exp(lnC)+exp(lnKp)-exp(lnK)-exp(lnY)+...
    phi/2*[exp(lnk1)*(exp(lnkp1)/exp(lnk1)-1)^2+exp(lnk2)*(exp(lnkp2)/exp(lnk2)-1)^2];

f=[f1;f1b;f2;f3;f4;f5;f5b;f6;f7;f8;f25;f26;f27;f28];

% 3) Define vectors of states and controls
xx=[lnk1 lnk2 lna1 lna2];
xxp=[lnkp1 lnkp2 lnap1 lnap2];

yy=[lnc1 lnc2 lntheta1 lntheta2  lnmu lnC lnK lnY lnl1 lnl2];
yyp=[lncp1 lncp2  lnthetap1 lnthetap2  lnmup lnCp lnKp lnYp lnlp1 lnlp2];

% 4) Compute analytical derivatives and evaluate them at the steady state
nx = length(xx);
ny = length(yy);

[fx,fxp,fy,fyp,fypyp,fypy,fypxp,fypx,fyyp,fyy,fyxp,fyx,fxpyp,fxpy,...
    fxpxp,fxpx,fxyp,fxy,fxxp,fxx]=anal_deriv(f,xx,yy,xxp,yyp);

assign_steadystate;
num_eval;

% 5) Construct log-linear approximation using the Klein (2000) algorithm
[gx,hx] = gx_hx(nfy,nfx,nfyp,nfxp);

if approx==2; 
etamat=zeros(nx,N+1);
for jj=1:N
    etamat(nx/2+jj,1)=sigma;
    etamat(nx/2+jj,1+jj)=sigma;
end
[GXX,HXX] = gxx_hxx(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx);
[GSS,HSS] = gss_hss(nfx,nfxp,nfy,nfyp,nfypyp,nfypy,nfypxp,nfypx,nfyyp,...
    nfyy,nfyxp,nfyx,nfxpyp,nfxpy,nfxpxp,nfxpx,nfxyp,nfxy,nfxxp,nfxx,hx,gx,GXX,etamat);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3. Construct initial guess for decision rule coefficients %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% 2) Construct monomial grid (Integration formula Cn:5.2 in Stroud (1971))
nx=4;
r_Mon=sqrt(3/5);
V_MON=2^nx;
B0_MON=(25*nx^2-115*nx+162)/162*V_MON;
B1_MON=(70-25*nx)/162*V_MON;
B2_MON=25/324*V_MON;

% build grid	
xgrid=zeros(2*nx^2+1,nx);
for j=1:nx
xgrid(2*j,j)=r_Mon;
xgrid(2*j+1,j)=-r_Mon;
end

ind=1+2*nx+1;
interim=[r_Mon r_Mon;r_Mon -r_Mon;-r_Mon r_Mon;-r_Mon -r_Mon];

for j=1:(nx-1)
    for i=j+1:nx
        xgrid(ind:ind+3,j)=interim(:,1);
        xgrid(ind:ind+3,i)=interim(:,2);
        ind=ind+4;
    end
end

% Construct Chebyshev polynomials from grid
Cheby_k1=chebpol_2(ord,xgrid(:,1));
Cheby_k2=chebpol_2(ord,xgrid(:,2));

Cheby_a1=chebpol_2(ord,xgrid(:,3));
Cheby_a2=chebpol_2(ord,xgrid(:,4));

% Construct state vectors from grid
k1_vec=scalup(xgrid(:,1),kmin,kmax);
k2_vec=scalup(xgrid(:,2),kmin,kmax);
K_vec=k1_vec+k2_vec;

a1_vec=scalup(xgrid(:,3),amin,amax);
a2_vec=scalup(xgrid(:,4),amin,amax);

% Construct regressor matrix to be used for perturbation initialization
INIT_REG=[log(k1_vec)-log(kss) log(k2_vec)-log(kss) log(a1_vec)-log(ass) log(a2_vec)-log(ass)];

% Construct next period's capital stocks and current consumption
lnkp1_vec=log(kss)+INIT_REG*hx(1,:)';
lnkp2_vec=log(kss)+INIT_REG*hx(2,:)';
lnmu_vec=lnmuss+INIT_REG*gx(5,:)';

if approx==2; 
for i=1:size(INIT_REG,1);  
    lnkp1_vec(i,1)=lnkp1_vec(i,1)+0.5*[INIT_REG(i,:)*squeeze(HXX(1,:,:))*INIT_REG(i,:)'+HSS(1)];
    lnkp2_vec(i,1)=lnkp2_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(HXX(2,:,:))*INIT_REG(i,:)'+HSS(2)];
    lnmu_vec(i,1)=lnmu_vec(i,1)'+0.5*[INIT_REG(i,:)*squeeze(GXX(5,:,:))*INIT_REG(i,:)'+GSS(5)];
end
end

% Compute initial guess for coefficient vectors by OLS
REG=makepoly_2_4(Cheby_k1,Cheby_k2,Cheby_a1,Cheby_a2);

dr_k1_coeff0=inv(REG'*REG)*REG'*exp(lnkp1_vec);
dr_k2_coeff0=inv(REG'*REG)*REG'*exp(lnkp2_vec);
dr_mu_coeff0=inv(REG'*REG)*REG'*(lnmu_vec);


dr_coeff0=[dr_k1_coeff0;dr_k2_coeff0;dr_mu_coeff0];


% Compute nodes to compute expectations
nshocks=N+1;
expect_r=sqrt((nshocks+2)/2);
expect_s=sqrt((nshocks+2)/4);
expect_V=3.14159265358979^(nshocks/2);
expect_A=2/(nshocks+2)*expect_V;
expect_B=(4-nshocks)/[2*(nshocks+2)^2]*expect_V;
expect_C=1/[(nshocks+2)^2]*expect_V;

nodes=zeros(2*nshocks^2+1,nshocks);

for j=1:nshocks
    nodes(2*j,j)=expect_r;
    nodes(2*j+1,j)=-expect_r;
end

ind=1+2*nshocks+1;
interim=[expect_s expect_s;expect_s -expect_s;-expect_s expect_s;-expect_s -expect_s];

for j=1:(nshocks-1)
    for i=j+1:nshocks
        nodes(ind:ind+3,j)=interim(:,1);
        nodes(ind:ind+3,i)=interim(:,2);
        ind=ind+4;
    end
end

nodes=nodes.*sqrt(2);

len_nodes=2*nshocks^2+1;
ones_nod=ones(len_nodes,1);

weights_vec=expect_V^(-1)*[expect_A;ones(nshocks*2,1)*expect_B;ones(length(nodes)-2*nshocks-1,1)*expect_C];


% Repeat the state vectors 14 times
k1_mat=kron(ones(len_nodes,1),k1_vec);
k2_mat=kron(ones(len_nodes,1),k2_vec);
K_mat=kron(ones(len_nodes,1),K_vec);

a1_mat=kron(ones(len_nodes,1),a1_vec);
a2_mat=kron(ones(len_nodes,1),a2_vec);

% Repeat the period t regressors len_nodes times
REG_mat=kron(ones(len_nodes,1),REG);

% Construct matrices for next periods exogenous states (outside loop saves
% time)
lnap1_mat=kron(ones(len_nodes,1),rho*log(a1_vec))+sigma*kron(nodes*[1;1;0],ones(size(REG,1),1));
lnap2_mat=kron(ones(len_nodes,1),rho*log(a2_vec))+sigma*kron(nodes*[1;0;1],ones(size(REG,1),1));

ap1_mat=exp(lnap1_mat);
ap2_mat=exp(lnap2_mat);

cheby_ap1_mat=chebpol_2(ord,scaldown(exp(lnap1_mat),amin,amax));
cheby_ap2_mat=chebpol_2(ord,scaldown(exp(lnap2_mat),amin,amax));

REG_A1=chebpol(8,2*[a1_mat-amin]/[amax-amin]-1);
REG_A2=chebpol(8,2*[a2_mat-amin]/[amax-amin]-1);

REG_K1=chebpol(8,2*[k1_mat-kmin]/[kmax-kmin]-1);
REG_K2=chebpol(8,2*[k2_mat-kmin]/[kmax-kmin]-1);

derive_labor_rules;
dr_coeff=dr_coeff0;
dr_coeff=fcsolve('projections_res',dr_coeff,[10000;1e-7;1e-8;1e-3;1]);
dr_coeff_A8N2=dr_coeff;
cpu1=cputime;
Time_Sol=cpu1-cpu0;
save('WSP_SOLUTION_A8N2');
regvec_labor=[regvec_labor1 regvec_labor2];
save PI_A8N2.mat dr_coeff_A8N2 kmin kmax amin amax mumin mumax regvec_labor
