% Resiudal function containing the projection conditions

function res=projections_res(dr_coeff0);


global N beta alpha delta sigma rho phi A gamma tau ord psi Le b chi mupar
global kmin kmax amin amax 
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat k3_mat k4_mat k5_mat k6_mat K_mat
global a1_mat a2_mat a3_mat a4_mat a5_mat a6_mat
global ap1_mat ap2_mat ap3_mat ap4_mat ap5_mat ap6_mat
global cheby_ap1_mat cheby_ap2_mat cheby_ap3_mat
global cheby_ap4_mat cheby_ap5_mat cheby_ap6_mat
global regvec_labor1 regvec_labor2 regvec_labor3 regvec_labor4 regvec_labor5 regvec_labor6 mumin mumax


% decompose coefficient vector
dr_k1=dr_coeff0(0*end/7+1:1*end/7);
dr_k2=dr_coeff0(1*end/7+1:2*end/7);
dr_k3=dr_coeff0(2*end/7+1:3*end/7);
dr_k4=dr_coeff0(3*end/7+1:4*end/7);
dr_k5=dr_coeff0(4*end/7+1:5*end/7);
dr_k6=dr_coeff0(5*end/7+1:6*end/7);
dr_mu=dr_coeff0(6*end/7+1:7*end/7);

kp1_mat=REG_mat*dr_k1;
kp2_mat=REG_mat*dr_k2;
kp3_mat=REG_mat*dr_k3;
kp4_mat=REG_mat*dr_k4;
kp5_mat=REG_mat*dr_k5;
kp6_mat=REG_mat*dr_k6;
Kp_mat=kp1_mat+kp2_mat+kp3_mat+kp4_mat+kp5_mat+kp6_mat;

cac1_mat=phi/2*k1_mat.*(kp1_mat./k1_mat-1).^2;
cac2_mat=phi/2*k2_mat.*(kp2_mat./k2_mat-1).^2;
cac3_mat=phi/2*k3_mat.*(kp3_mat./k3_mat-1).^2;
cac4_mat=phi/2*k4_mat.*(kp4_mat./k4_mat-1).^2;
cac5_mat=phi/2*k5_mat.*(kp5_mat./k5_mat-1).^2;
cac6_mat=phi/2*k6_mat.*(kp6_mat./k6_mat-1).^2;
CAC_mat=cac1_mat+cac2_mat+cac3_mat+cac4_mat+cac5_mat+cac6_mat;

mu_mat=exp(REG_mat*dr_mu);

REG_MU=chebpol(8,scaldown(mu_mat,mumin,mumax));

REG_A1=chebpol(8,scaldown(a1_mat,amin,amax));
REG_A2=chebpol(8,scaldown(a2_mat,amin,amax));
REG_A3=chebpol(8,scaldown(a3_mat,amin,amax));
REG_A4=chebpol(8,scaldown(a4_mat,amin,amax));
REG_A5=chebpol(8,scaldown(a5_mat,amin,amax));
REG_A6=chebpol(8,scaldown(a6_mat,amin,amax));

REG_K1=chebpol(8,scaldown(k1_mat,kmin,kmax));
REG_K2=chebpol(8,scaldown(k2_mat,kmin,kmax));
REG_K3=chebpol(8,scaldown(k3_mat,kmin,kmax));
REG_K4=chebpol(8,scaldown(k4_mat,kmin,kmax));
REG_K5=chebpol(8,scaldown(k5_mat,kmin,kmax));
REG_K6=chebpol(8,scaldown(k6_mat,kmin,kmax));

REGMAT1=makepoly_MUAK(REG_MU,REG_A1,REG_K1);
REGMAT2=makepoly_MUAK(REG_MU,REG_A2,REG_K2);
REGMAT3=makepoly_MUAK(REG_MU,REG_A3,REG_K3);
REGMAT4=makepoly_MUAK(REG_MU,REG_A4,REG_K4);
REGMAT5=makepoly_MUAK(REG_MU,REG_A5,REG_K5);
REGMAT6=makepoly_MUAK(REG_MU,REG_A6,REG_K6);

l1_mat=REGMAT1*regvec_labor1;
l2_mat=REGMAT2*regvec_labor2;
l3_mat=REGMAT3*regvec_labor3;
l4_mat=REGMAT4*regvec_labor4;
l5_mat=REGMAT5*regvec_labor5;
l6_mat=REGMAT6*regvec_labor6;

c1_mat=[[b(1)*(Le-l1_mat).^(-1/chi(1))]./[a1_mat.*(1-alpha).*A.*(l1_mat.^(mupar(1)-1)).*...
    (alpha.*k1_mat.^(mupar(1))+(1-alpha)*l1_mat.^mupar(1)).^(1/mupar(1)-1)]].^(-chi(1));
c2_mat=[[b(2)*(Le-l2_mat).^(-1/chi(2))]./[a2_mat.*(1-alpha).*A.*(l2_mat.^(mupar(2)-1)).*...
    (alpha.*k2_mat.^(mupar(2))+(1-alpha)*l2_mat.^mupar(2)).^(1/mupar(2)-1)]].^(-chi(2));
c3_mat=[[b(3)*(Le-l3_mat).^(-1/chi(3))]./[a3_mat.*(1-alpha).*A.*(l3_mat.^(mupar(3)-1)).*...
    (alpha.*k3_mat.^(mupar(3))+(1-alpha)*l3_mat.^mupar(3)).^(1/mupar(3)-1)]].^(-chi(3));
c4_mat=[[b(4)*(Le-l4_mat).^(-1/chi(4))]./[a4_mat.*(1-alpha).*A.*(l4_mat.^(mupar(4)-1)).*...
    (alpha.*k4_mat.^(mupar(4))+(1-alpha)*l4_mat.^mupar(4)).^(1/mupar(4)-1)]].^(-chi(4));
c5_mat=[[b(5)*(Le-l5_mat).^(-1/chi(5))]./[a5_mat.*(1-alpha).*A.*(l5_mat.^(mupar(5)-1)).*...
    (alpha.*k5_mat.^(mupar(5))+(1-alpha)*l5_mat.^mupar(5)).^(1/mupar(5)-1)]].^(-chi(5));
c6_mat=[[b(6)*(Le-l6_mat).^(-1/chi(6))]./[a6_mat.*(1-alpha).*A.*(l6_mat.^(mupar(6)-1)).*...
    (alpha.*k6_mat.^(mupar(6))+(1-alpha)*l6_mat.^mupar(6)).^(1/mupar(6)-1)]].^(-chi(6));
C_mat=c1_mat+c2_mat+c3_mat+c4_mat+c5_mat+c6_mat;

mu1_mat=[tau(1).*c1_mat.^(-1/chi(1)).*[[c1_mat.^(1-1/chi(1))+b(1).*(Le-l1_mat).^(1-1/chi(1))].^[(1-1/gamma(1))./(1-1/chi(1))-1]]];
mu2_mat=[tau(2).*c2_mat.^(-1/chi(2)).*[[c2_mat.^(1-1/chi(2))+b(2).*(Le-l2_mat).^(1-1/chi(2))].^[(1-1/gamma(2))./(1-1/chi(2))-1]]];
mu3_mat=[tau(3).*c3_mat.^(-1/chi(3)).*[[c3_mat.^(1-1/chi(3))+b(3).*(Le-l3_mat).^(1-1/chi(3))].^[(1-1/gamma(3))./(1-1/chi(3))-1]]];
mu4_mat=[tau(4).*c4_mat.^(-1/chi(4)).*[[c4_mat.^(1-1/chi(4))+b(4).*(Le-l4_mat).^(1-1/chi(4))].^[(1-1/gamma(4))./(1-1/chi(4))-1]]];
mu5_mat=[tau(5).*c5_mat.^(-1/chi(5)).*[[c5_mat.^(1-1/chi(5))+b(5).*(Le-l5_mat).^(1-1/chi(5))].^[(1-1/gamma(5))./(1-1/chi(5))-1]]];
mu6_mat=[tau(6).*c6_mat.^(-1/chi(6)).*[[c6_mat.^(1-1/chi(6))+b(6).*(Le-l6_mat).^(1-1/chi(6))].^[(1-1/gamma(6))./(1-1/chi(6))-1]]];

% compute output levels
y1_mat=A.*a1_mat.*[alpha.*k1_mat.^mupar(1)+(1-alpha).*l1_mat.^mupar(1)].^(1/mupar(1));
y2_mat=A.*a2_mat.*[alpha.*k2_mat.^mupar(2)+(1-alpha).*l2_mat.^mupar(2)].^(1/mupar(2));
y3_mat=A.*a3_mat.*[alpha.*k3_mat.^mupar(3)+(1-alpha).*l3_mat.^mupar(3)].^(1/mupar(3));
y4_mat=A.*a4_mat.*[alpha.*k4_mat.^mupar(4)+(1-alpha).*l4_mat.^mupar(4)].^(1/mupar(4));
y5_mat=A.*a5_mat.*[alpha.*k5_mat.^mupar(5)+(1-alpha).*l5_mat.^mupar(5)].^(1/mupar(5));
y6_mat=A.*a6_mat.*[alpha.*k6_mat.^mupar(6)+(1-alpha).*l6_mat.^mupar(6)].^(1/mupar(6));
Y_mat=y1_mat+y2_mat+y3_mat+y4_mat+y5_mat+y6_mat;

% compute chebyshev polynomials from next period's endogenous
% states
cheby_kp1_mat=chebpol_2(ord,2*[kp1_mat-kmin]/[kmax-kmin]-1);
cheby_kp2_mat=chebpol_2(ord,2*[kp2_mat-kmin]/[kmax-kmin]-1);
cheby_kp3_mat=chebpol_2(ord,2*[kp3_mat-kmin]/[kmax-kmin]-1);
cheby_kp4_mat=chebpol_2(ord,2*[kp4_mat-kmin]/[kmax-kmin]-1);
cheby_kp5_mat=chebpol_2(ord,2*[kp5_mat-kmin]/[kmax-kmin]-1);
cheby_kp6_mat=chebpol_2(ord,2*[kp6_mat-kmin]/[kmax-kmin]-1);

REGp=makepoly_2_12(cheby_kp1_mat,cheby_kp2_mat,cheby_kp3_mat,cheby_kp4_mat,cheby_kp5_mat,cheby_kp6_mat,...
    cheby_ap1_mat,cheby_ap2_mat,cheby_ap3_mat,cheby_ap4_mat,cheby_ap5_mat,cheby_ap6_mat);

kpp1_mat=REGp*dr_k1;
kpp2_mat=REGp*dr_k2;
kpp3_mat=REGp*dr_k3;
kpp4_mat=REGp*dr_k4;
kpp5_mat=REGp*dr_k5;
kpp6_mat=REGp*dr_k6;
Kpp_mat=kpp1_mat+kpp2_mat+kpp3_mat+kpp4_mat+kpp5_mat+kpp6_mat;

cacp1_mat=phi/2*kp1_mat.*(kpp1_mat./kp1_mat-1).^2;
cacp2_mat=phi/2*kp2_mat.*(kpp2_mat./kp2_mat-1).^2;
cacp3_mat=phi/2*kp3_mat.*(kpp3_mat./kp3_mat-1).^2;
cacp4_mat=phi/2*kp4_mat.*(kpp4_mat./kp4_mat-1).^2;
cacp5_mat=phi/2*kp5_mat.*(kpp5_mat./kp5_mat-1).^2;
cacp6_mat=phi/2*kp6_mat.*(kpp6_mat./kp6_mat-1).^2;
CACp_mat=cacp1_mat+cacp2_mat+cacp3_mat+cacp4_mat+cacp5_mat+cacp6_mat;

mup_mat=exp(REGp*dr_mu);

REG_MUp=chebpol(8,scaldown(mup_mat,mumin,mumax));

REG_Ap1=chebpol(8,scaldown(ap1_mat,amin,amax));
REG_Ap2=chebpol(8,scaldown(ap2_mat,amin,amax));
REG_Ap3=chebpol(8,scaldown(ap3_mat,amin,amax));
REG_Ap4=chebpol(8,scaldown(ap4_mat,amin,amax));
REG_Ap5=chebpol(8,scaldown(ap5_mat,amin,amax));
REG_Ap6=chebpol(8,scaldown(ap6_mat,amin,amax));

REG_Kp1=chebpol(8,scaldown(kp1_mat,kmin,kmax));
REG_Kp2=chebpol(8,scaldown(kp2_mat,kmin,kmax));
REG_Kp3=chebpol(8,scaldown(kp3_mat,kmin,kmax));
REG_Kp4=chebpol(8,scaldown(kp4_mat,kmin,kmax));
REG_Kp5=chebpol(8,scaldown(kp5_mat,kmin,kmax));
REG_Kp6=chebpol(8,scaldown(kp6_mat,kmin,kmax));

REGMATp1=makepoly_MUAK(REG_MUp,REG_Ap1,REG_Kp1);
REGMATp2=makepoly_MUAK(REG_MUp,REG_Ap2,REG_Kp2);
REGMATp3=makepoly_MUAK(REG_MUp,REG_Ap3,REG_Kp3);
REGMATp4=makepoly_MUAK(REG_MUp,REG_Ap4,REG_Kp4);
REGMATp5=makepoly_MUAK(REG_MUp,REG_Ap5,REG_Kp5);
REGMATp6=makepoly_MUAK(REG_MUp,REG_Ap6,REG_Kp6);

lp1_mat=REGMATp1*regvec_labor1;
lp2_mat=REGMATp2*regvec_labor2;
lp3_mat=REGMATp3*regvec_labor3;
lp4_mat=REGMATp4*regvec_labor4;
lp5_mat=REGMATp5*regvec_labor5;
lp6_mat=REGMATp6*regvec_labor6;

cp1_mat=[[b(1)*(Le-lp1_mat).^(-1/chi(1))]./[ap1_mat.*(1-alpha).*A.*(lp1_mat.^(mupar(1)-1)).*...
    (alpha.*kp1_mat.^(mupar(1))+(1-alpha)*lp1_mat.^mupar(1)).^(1/mupar(1)-1)]].^(-chi(1));
cp2_mat=[[b(2)*(Le-lp2_mat).^(-1/chi(2))]./[ap2_mat.*(1-alpha).*A.*(lp2_mat.^(mupar(2)-1)).*...
    (alpha.*kp2_mat.^(mupar(2))+(1-alpha)*lp2_mat.^mupar(2)).^(1/mupar(2)-1)]].^(-chi(2));
cp3_mat=[[b(3)*(Le-lp3_mat).^(-1/chi(3))]./[ap3_mat.*(1-alpha).*A.*(lp3_mat.^(mupar(3)-1)).*...
    (alpha.*kp3_mat.^(mupar(3))+(1-alpha)*lp3_mat.^mupar(3)).^(1/mupar(3)-1)]].^(-chi(3));
cp4_mat=[[b(4)*(Le-lp4_mat).^(-1/chi(4))]./[ap4_mat.*(1-alpha).*A.*(lp4_mat.^(mupar(4)-1)).*...
    (alpha.*kp4_mat.^(mupar(4))+(1-alpha)*lp4_mat.^mupar(4)).^(1/mupar(4)-1)]].^(-chi(4));
cp5_mat=[[b(5)*(Le-lp5_mat).^(-1/chi(5))]./[ap5_mat.*(1-alpha).*A.*(lp5_mat.^(mupar(5)-1)).*...
    (alpha.*kp5_mat.^(mupar(5))+(1-alpha)*lp5_mat.^mupar(5)).^(1/mupar(5)-1)]].^(-chi(5));
cp6_mat=[[b(6)*(Le-lp6_mat).^(-1/chi(6))]./[ap6_mat.*(1-alpha).*A.*(lp6_mat.^(mupar(6)-1)).*...
    (alpha.*kp6_mat.^(mupar(6))+(1-alpha)*lp6_mat.^mupar(6)).^(1/mupar(6)-1)]].^(-chi(6));
Cp_mat=cp1_mat+cp2_mat+cp3_mat+cp4_mat+cp5_mat+cp6_mat;

mup1_mat=[tau(1).*cp1_mat.^(-1/chi(1)).*[cp1_mat.^(1-1/chi(1))+b(1).*(Le-lp1_mat).^(1-1/chi(1))].^[(1-1/gamma(1))./(1-1/chi(1))-1]];
mup2_mat=[tau(2).*cp2_mat.^(-1/chi(2)).*[cp2_mat.^(1-1/chi(2))+b(2).*(Le-lp2_mat).^(1-1/chi(2))].^[(1-1/gamma(2))./(1-1/chi(2))-1]];
mup3_mat=[tau(3).*cp3_mat.^(-1/chi(3)).*[cp3_mat.^(1-1/chi(3))+b(3).*(Le-lp3_mat).^(1-1/chi(3))].^[(1-1/gamma(3))./(1-1/chi(3))-1]];
mup4_mat=[tau(4).*cp4_mat.^(-1/chi(4)).*[cp4_mat.^(1-1/chi(4))+b(4).*(Le-lp4_mat).^(1-1/chi(4))].^[(1-1/gamma(4))./(1-1/chi(4))-1]];
mup5_mat=[tau(5).*cp5_mat.^(-1/chi(5)).*[cp5_mat.^(1-1/chi(5))+b(5).*(Le-lp5_mat).^(1-1/chi(5))].^[(1-1/gamma(5))./(1-1/chi(5))-1]];
mup6_mat=[tau(6).*cp6_mat.^(-1/chi(6)).*[cp6_mat.^(1-1/chi(6))+b(6).*(Le-lp6_mat).^(1-1/chi(6))].^[(1-1/gamma(6))./(1-1/chi(6))-1]];

% compute output levels
yp1_mat=A.*ap1_mat.*[alpha.*kp1_mat.^mupar(1)+(1-alpha).*lp1_mat.^mupar(1)].^(1/mupar(1));
yp2_mat=A.*ap2_mat.*[alpha.*kp2_mat.^mupar(2)+(1-alpha).*lp2_mat.^mupar(2)].^(1/mupar(2));
yp3_mat=A.*ap3_mat.*[alpha.*kp3_mat.^mupar(3)+(1-alpha).*lp3_mat.^mupar(3)].^(1/mupar(3));
yp4_mat=A.*ap4_mat.*[alpha.*kp4_mat.^mupar(4)+(1-alpha).*lp4_mat.^mupar(4)].^(1/mupar(4));
yp5_mat=A.*ap5_mat.*[alpha.*kp5_mat.^mupar(5)+(1-alpha).*lp5_mat.^mupar(5)].^(1/mupar(5));
yp6_mat=A.*ap6_mat.*[alpha.*kp6_mat.^mupar(6)+(1-alpha).*lp6_mat.^mupar(6)].^(1/mupar(6));
Yp_mat=yp1_mat+yp2_mat+yp3_mat+yp4_mat+yp5_mat+yp6_mat;


NN=size(REGp,1);
NN2=NN/14;

LHS1=mu1_mat(1:NN2).*(1+phi.*(kp1_mat(1:NN2)./k1_mat(1:NN2)-1));   
LHS2=mu2_mat(1:NN2).*(1+phi.*(kp2_mat(1:NN2)./k2_mat(1:NN2)-1)); 
LHS3=mu3_mat(1:NN2).*(1+phi.*(kp3_mat(1:NN2)./k3_mat(1:NN2)-1));
LHS4=mu4_mat(1:NN2).*(1+phi.*(kp4_mat(1:NN2)./k4_mat(1:NN2)-1));
LHS5=mu5_mat(1:NN2).*(1+phi.*(kp5_mat(1:NN2)./k5_mat(1:NN2)-1));
LHS6=mu6_mat(1:NN2).*(1+phi.*(kp6_mat(1:NN2)./k6_mat(1:NN2)-1));
LHS7=Y_mat(1:NN2);

        
RHS1=mean(reshape(beta*mup1_mat.*...
    [[1+phi*(1+1/2.*(kpp1_mat./kp1_mat-1)).*(kpp1_mat./kp1_mat-1)]+...
    A*ap1_mat.*alpha.*kp1_mat.^(mupar(1)-1).*[alpha.*kp1_mat.^(mupar(1))+(1-alpha).*lp1_mat.^mupar(1)].^(1./mupar(1)-1)],NN/14,14),2);
RHS2=mean(reshape(beta*mup2_mat.*...
    [[1+phi*(1+1/2.*(kpp2_mat./kp2_mat-1)).*(kpp2_mat./kp2_mat-1)]+...
    A*ap2_mat.*alpha.*kp2_mat.^(mupar(2)-1).*[alpha.*kp2_mat.^(mupar(2))+(1-alpha).*lp2_mat.^mupar(2)].^(1./mupar(2)-1)],NN/14,14),2);
RHS3=mean(reshape(beta*mup3_mat.*...
     [[1+phi*(1+1/2.*(kpp3_mat./kp3_mat-1)).*(kpp3_mat./kp3_mat-1)]+...
    A*ap3_mat.*alpha.*kp3_mat.^(mupar(3)-1).*[alpha.*kp3_mat.^(mupar(3))+(1-alpha).*lp3_mat.^mupar(3)].^(1./mupar(3)-1)],NN/14,14),2);
RHS4=mean(reshape(beta*mup4_mat.*...
     [[1+phi*(1+1/2.*(kpp4_mat./kp4_mat-1)).*(kpp4_mat./kp4_mat-1)]+...
    A*ap4_mat.*alpha.*kp4_mat.^(mupar(4)-1).*[alpha.*kp4_mat.^(mupar(4))+(1-alpha).*lp4_mat.^mupar(4)].^(1./mupar(4)-1)],NN/14,14),2);
RHS5=mean(reshape(beta*mup5_mat.*...
     [[1+phi*(1+1/2.*(kpp5_mat./kp5_mat-1)).*(kpp5_mat./kp5_mat-1)]+...
    A*ap5_mat.*alpha.*kp5_mat.^(mupar(5)-1).*[alpha.*kp5_mat.^(mupar(5))+(1-alpha).*lp5_mat.^mupar(5)].^(1./mupar(5)-1)],NN/14,14),2);
RHS6=mean(reshape(beta*mup6_mat.*...
    [[1+phi*(1+1/2.*(kpp6_mat./kp6_mat-1)).*(kpp6_mat./kp6_mat-1)]+...
    A*ap6_mat.*alpha.*kp6_mat.^(mupar(6)-1).*[alpha.*kp6_mat.^(mupar(6))+(1-alpha).*lp6_mat.^mupar(6)].^(1./mupar(6)-1)],NN/14,14),2);
RHS7=C_mat(1:NN2)+[Kp_mat(1:NN2)-K_mat(1:NN2)]+CAC_mat(1:NN2);
        
RES1=[LHS1-RHS1]./LHS1;
RES2=[LHS2-RHS2]./LHS2;
RES3=[LHS3-RHS3]./LHS3;
RES4=[LHS4-RHS4]./LHS4;
RES5=[LHS5-RHS5]./LHS5;
RES6=[LHS6-RHS6]./LHS6;
RES7=[LHS7-RHS7]./LHS7;

RESIDUALS=[RES1 RES2 RES3 RES4 RES5 RES6 RES7]; 

REG=REG_mat(1:NN2,:);
weights=[B0_MON;ones(4*N,1)*B1_MON;ones(length(RES1)-4*N-1,1)*B2_MON];
res=[REG'*(RES1.*weights);REG'*(RES2.*weights);REG'*(RES3.*weights);...
    REG'*(RES4.*weights);REG'*(RES5.*weights);REG'*(RES6.*weights);REG'*(RES7.*weights)];
%disp(mean(mean(abs(RESIDUALS))));