% Resiudal function containing the projection conditions

function res=projections_res(dr_coeff0);


global N beta alpha delta sigma rho phi A gamma tau ord
global kmin kmax amin amax
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat  K_mat
global a1_mat a2_mat 
global ap1_mat ap2_mat 
global y1_mat y2_mat Y_mat
global cheby_ap1_mat cheby_ap2_mat 
global regvec C_min C_max
global weights_vec

% decompose coefficient vector
dr_k1=dr_coeff0(0*end/2+1:1*end/2);
dr_k2=dr_coeff0(1*end/2+1:2*end/2);

kp1_mat=REG_mat*dr_k1;
kp2_mat=REG_mat*dr_k2;
Kp_mat=kp1_mat+kp2_mat;

cac1_mat=phi/2*k1_mat.*(kp1_mat./k1_mat-1).^2;
cac2_mat=phi/2*k2_mat.*(kp2_mat./k2_mat-1).^2;
CAC_mat=cac1_mat+cac2_mat;

C_mat=Y_mat-[Kp_mat-K_mat]-CAC_mat;

REGCC=chebpol(8,scaldown(C_mat,C_min,C_max));

c1_mat=REGCC*regvec;
c2_mat=[tau(1)./tau(2)*c1_mat.^(-1/gamma(1))].^(-gamma(2));

% compute chebyshev polynomials from next period's endogenous
% states
cheby_kp1_mat=chebpol_2(ord,2*[kp1_mat-kmin]/[kmax-kmin]-1);
cheby_kp2_mat=chebpol_2(ord,2*[kp2_mat-kmin]/[kmax-kmin]-1);

REGp=makepoly_2_4(cheby_kp1_mat,cheby_kp2_mat,cheby_ap1_mat,cheby_ap2_mat);

kpp1_mat=REGp*dr_k1;
kpp2_mat=REGp*dr_k2;
Kpp_mat=kpp1_mat+kpp2_mat;

% compute output levels
yp1_mat=A.*ap1_mat.*kp1_mat.^alpha;
yp2_mat=A.*ap2_mat.*kp2_mat.^alpha;
Yp_mat=yp1_mat+yp2_mat;

cacp1_mat=phi/2*kp1_mat.*(kpp1_mat./kp1_mat-1).^2;
cacp2_mat=phi/2*kp2_mat.*(kpp2_mat./kp2_mat-1).^2;
CACp_mat=cacp1_mat+cacp2_mat;

Cp_mat=Yp_mat-[Kpp_mat-Kp_mat]-CACp_mat;

REGCC_P=chebpol(8,scaldown(Cp_mat,C_min,C_max));

cp1_mat=REGCC_P*regvec;   
cp2_mat=[tau(1)./tau(2)*cp1_mat.^(-1/gamma(1))].^(-gamma(2));


NN=size(REGp,1);
NN1=length(nodes);
NN2=NN/NN1;


LHS1=c1_mat(1:NN2).^(-1/gamma(1)).*(1+phi.*(kp1_mat(1:NN2)./k1_mat(1:NN2)-1));   
LHS2=c2_mat(1:NN2).^(-1/gamma(2)).*(1+phi.*(kp2_mat(1:NN2)./k2_mat(1:NN2)-1));  
        
RHS1=reshape(beta*[cp1_mat.^(-1/gamma(1))].*[[1+phi*(1+1/2.*(kpp1_mat./kp1_mat-1)).*(kpp1_mat./kp1_mat-1)]+...
    A*ap1_mat.*alpha.*kp1_mat.^(alpha-1)],NN2,NN1)*weights_vec;
RHS2=reshape(beta*[cp2_mat.^(-1/gamma(2))].*[[1+phi*(1+1/2.*(kpp2_mat./kp2_mat-1)).*(kpp2_mat./kp2_mat-1)]+...
   A*ap2_mat.*alpha.*kp2_mat.^(alpha-1)],NN2,NN1)*weights_vec;
        
RES1=[LHS1-RHS1]./LHS1;
RES2=[LHS2-RHS2]./LHS2;



RESIDUALS=[RES1 RES2]; 

REG=REG_mat(1:NN2,:);
weights=[B0_MON;ones(4*N,1)*B1_MON;ones(length(RES1)-4*N-1,1)*B2_MON];
res=[REG'*(RES1.*weights);REG'*(RES2.*weights)];
%disp(sum(abs(res)));