% Resiudal function containing the projection conditions

function res=projections_res(dr_coeff0);


global N beta alpha delta sigma rho phi A gamma tau ord b eta
global kmin kmax amin amax
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat k3_mat k4_mat k5_mat k6_mat k7_mat k8_mat K_mat
global a1_mat a2_mat a3_mat a4_mat a5_mat a6_mat a7_mat a8_mat 
global ap1_mat ap2_mat ap3_mat ap4_mat ap5_mat ap6_mat ap7_mat ap8_mat 
global y1_mat y2_mat y3_mat y4_mat y5_mat y6_mat y7_mat y8_mat  Y_mat
global cheby_ap1_mat cheby_ap2_mat cheby_ap3_mat
global cheby_ap4_mat cheby_ap5_mat cheby_ap6_mat
global cheby_ap7_mat cheby_ap8_mat
global regvec C_min C_max


% decompose coefficient vector
dr_k1=dr_coeff0(0*end/9+1:1*end/9);
dr_k2=dr_coeff0(1*end/9+1:2*end/9);
dr_k3=dr_coeff0(2*end/9+1:3*end/9);
dr_k4=dr_coeff0(3*end/9+1:4*end/9);
dr_k5=dr_coeff0(4*end/9+1:5*end/9);
dr_k6=dr_coeff0(5*end/9+1:6*end/9);
dr_k7=dr_coeff0(6*end/9+1:7*end/9);
dr_k8=dr_coeff0(7*end/9+1:8*end/9);
dr_C=dr_coeff0(8*end/9+1:9*end/9);

kp1_mat=REG_mat*dr_k1;
kp2_mat=REG_mat*dr_k2;
kp3_mat=REG_mat*dr_k3;
kp4_mat=REG_mat*dr_k4;
kp5_mat=REG_mat*dr_k5;
kp6_mat=REG_mat*dr_k6;
kp7_mat=REG_mat*dr_k7;
kp8_mat=REG_mat*dr_k8;
Kp_mat=kp1_mat+kp2_mat+kp3_mat+kp4_mat+kp5_mat+kp6_mat+kp7_mat+kp8_mat;

cac1_mat=phi/2*k1_mat.*(kp1_mat./k1_mat-1).^2;
cac2_mat=phi/2*k2_mat.*(kp2_mat./k2_mat-1).^2;
cac3_mat=phi/2*k3_mat.*(kp3_mat./k3_mat-1).^2;
cac4_mat=phi/2*k4_mat.*(kp4_mat./k4_mat-1).^2;
cac5_mat=phi/2*k5_mat.*(kp5_mat./k5_mat-1).^2;
cac6_mat=phi/2*k6_mat.*(kp6_mat./k6_mat-1).^2;
cac7_mat=phi/2*k7_mat.*(kp7_mat./k7_mat-1).^2;
cac8_mat=phi/2*k8_mat.*(kp8_mat./k8_mat-1).^2;
CAC_mat=cac1_mat+cac2_mat+cac3_mat+cac4_mat+cac5_mat+cac6_mat+cac7_mat+cac8_mat;

C_mat=REG_mat*dr_C;

REGCC=chebpol(8,scaldown(C_mat,C_min,C_max));
c1_mat=REGCC*regvec;
c2_mat=[tau(1)./tau(2)*c1_mat.^(-1/gamma(1))].^(-gamma(2));
c3_mat=[tau(1)./tau(3)*c1_mat.^(-1/gamma(1))].^(-gamma(3));
c4_mat=[tau(1)./tau(4)*c1_mat.^(-1/gamma(1))].^(-gamma(4));
c5_mat=[tau(1)./tau(5)*c1_mat.^(-1/gamma(1))].^(-gamma(5));
c6_mat=[tau(1)./tau(6)*c1_mat.^(-1/gamma(1))].^(-gamma(6));
c7_mat=[tau(1)./tau(7)*c1_mat.^(-1/gamma(1))].^(-gamma(7));
c8_mat=[tau(1)./tau(8)*c1_mat.^(-1/gamma(1))].^(-gamma(8));

l1_mat=[1/b(1).*[c1_mat.^(-1./gamma(1)).*a1_mat.*(1-alpha).*A.*(k1_mat.^alpha)]].^(1/(alpha-1/eta(1)));
l2_mat=[1/b(2).*[c2_mat.^(-1./gamma(2)).*a2_mat.*(1-alpha).*A.*(k2_mat.^alpha)]].^(1/(alpha-1/eta(2)));
l3_mat=[1/b(3).*[c3_mat.^(-1./gamma(3)).*a3_mat.*(1-alpha).*A.*(k3_mat.^alpha)]].^(1/(alpha-1/eta(3)));
l4_mat=[1/b(4).*[c4_mat.^(-1./gamma(4)).*a4_mat.*(1-alpha).*A.*(k4_mat.^alpha)]].^(1/(alpha-1/eta(4)));
l5_mat=[1/b(5).*[c5_mat.^(-1./gamma(5)).*a5_mat.*(1-alpha).*A.*(k5_mat.^alpha)]].^(1/(alpha-1/eta(5)));
l6_mat=[1/b(6).*[c6_mat.^(-1./gamma(6)).*a6_mat.*(1-alpha).*A.*(k6_mat.^alpha)]].^(1/(alpha-1/eta(6)));
l7_mat=[1/b(7).*[c7_mat.^(-1./gamma(7)).*a7_mat.*(1-alpha).*A.*(k7_mat.^alpha)]].^(1/(alpha-1/eta(7)));
l8_mat=[1/b(8).*[c8_mat.^(-1./gamma(8)).*a8_mat.*(1-alpha).*A.*(k8_mat.^alpha)]].^(1/(alpha-1/eta(8)));


% compute output levels
y1_mat=A.*a1_mat.*k1_mat.^alpha.*l1_mat.^(1-alpha);
y2_mat=A.*a2_mat.*k2_mat.^alpha.*l2_mat.^(1-alpha);
y3_mat=A.*a3_mat.*k3_mat.^alpha.*l3_mat.^(1-alpha);
y4_mat=A.*a4_mat.*k4_mat.^alpha.*l4_mat.^(1-alpha);
y5_mat=A.*a5_mat.*k5_mat.^alpha.*l5_mat.^(1-alpha);
y6_mat=A.*a6_mat.*k6_mat.^alpha.*l6_mat.^(1-alpha);
y7_mat=A.*a7_mat.*k7_mat.^alpha.*l7_mat.^(1-alpha);
y8_mat=A.*a8_mat.*k8_mat.^alpha.*l8_mat.^(1-alpha);

Y_mat=y1_mat+y2_mat+y3_mat+y4_mat+y5_mat+y6_mat+y7_mat+y8_mat;

% compute chebyshev polynomials from next period's endogenous
% states
cheby_kp1_mat=chebpol_2(ord,2*[kp1_mat-kmin]/[kmax-kmin]-1);
cheby_kp2_mat=chebpol_2(ord,2*[kp2_mat-kmin]/[kmax-kmin]-1);
cheby_kp3_mat=chebpol_2(ord,2*[kp3_mat-kmin]/[kmax-kmin]-1);
cheby_kp4_mat=chebpol_2(ord,2*[kp4_mat-kmin]/[kmax-kmin]-1);
cheby_kp5_mat=chebpol_2(ord,2*[kp5_mat-kmin]/[kmax-kmin]-1);
cheby_kp6_mat=chebpol_2(ord,2*[kp6_mat-kmin]/[kmax-kmin]-1);
cheby_kp7_mat=chebpol_2(ord,2*[kp7_mat-kmin]/[kmax-kmin]-1);
cheby_kp8_mat=chebpol_2(ord,2*[kp8_mat-kmin]/[kmax-kmin]-1);

REGp=makepoly_2_16(cheby_kp1_mat,cheby_kp2_mat,cheby_kp3_mat,cheby_kp4_mat,cheby_kp5_mat,cheby_kp6_mat,...
    cheby_kp7_mat,cheby_kp8_mat,...
    cheby_ap1_mat,cheby_ap2_mat,cheby_ap3_mat,cheby_ap4_mat,cheby_ap5_mat,cheby_ap6_mat,...
     cheby_ap7_mat,cheby_ap8_mat);

kpp1_mat=REGp*dr_k1;
kpp2_mat=REGp*dr_k2;
kpp3_mat=REGp*dr_k3;
kpp4_mat=REGp*dr_k4;
kpp5_mat=REGp*dr_k5;
kpp6_mat=REGp*dr_k6;
kpp7_mat=REGp*dr_k7;
kpp8_mat=REGp*dr_k8;
Kpp_mat=kpp1_mat+kpp2_mat+kpp3_mat+kpp4_mat+kpp5_mat+kpp6_mat+kpp7_mat+kpp8_mat;


Cp_mat=REGp*dr_C;

REGCC_P=chebpol(8,scaldown(Cp_mat,C_min,C_max));
cp1_mat=REGCC_P*regvec;   
cp2_mat=[tau(1)./tau(2)*cp1_mat.^(-1/gamma(1))].^(-gamma(2));
cp3_mat=[tau(1)./tau(3)*cp1_mat.^(-1/gamma(1))].^(-gamma(3));
cp4_mat=[tau(1)./tau(4)*cp1_mat.^(-1/gamma(1))].^(-gamma(4));
cp5_mat=[tau(1)./tau(5)*cp1_mat.^(-1/gamma(1))].^(-gamma(5));
cp6_mat=[tau(1)./tau(6)*cp1_mat.^(-1/gamma(1))].^(-gamma(6));
cp7_mat=[tau(1)./tau(7)*cp1_mat.^(-1/gamma(1))].^(-gamma(7));
cp8_mat=[tau(1)./tau(8)*cp1_mat.^(-1/gamma(1))].^(-gamma(8));

lp1_mat=[1/b(1).*[cp1_mat.^(-1./gamma(1)).*ap1_mat.*(1-alpha).*A.*(kp1_mat.^alpha)]].^(1/(alpha-1/eta(1)));
lp2_mat=[1/b(2).*[cp2_mat.^(-1./gamma(2)).*ap2_mat.*(1-alpha).*A.*(kp2_mat.^alpha)]].^(1/(alpha-1/eta(2)));
lp3_mat=[1/b(3).*[cp3_mat.^(-1./gamma(3)).*ap3_mat.*(1-alpha).*A.*(kp3_mat.^alpha)]].^(1/(alpha-1/eta(3)));
lp4_mat=[1/b(4).*[cp4_mat.^(-1./gamma(4)).*ap4_mat.*(1-alpha).*A.*(kp4_mat.^alpha)]].^(1/(alpha-1/eta(4)));
lp5_mat=[1/b(5).*[cp5_mat.^(-1./gamma(5)).*ap5_mat.*(1-alpha).*A.*(kp5_mat.^alpha)]].^(1/(alpha-1/eta(5)));
lp6_mat=[1/b(6).*[cp6_mat.^(-1./gamma(6)).*ap6_mat.*(1-alpha).*A.*(kp6_mat.^alpha)]].^(1/(alpha-1/eta(6)));
lp7_mat=[1/b(7).*[cp7_mat.^(-1./gamma(7)).*ap7_mat.*(1-alpha).*A.*(kp7_mat.^alpha)]].^(1/(alpha-1/eta(7)));
lp8_mat=[1/b(8).*[cp8_mat.^(-1./gamma(8)).*ap8_mat.*(1-alpha).*A.*(kp8_mat.^alpha)]].^(1/(alpha-1/eta(8)));

% compute output levels
yp1_mat=A.*ap1_mat.*kp1_mat.^alpha.*lp1_mat.^(1-alpha);
yp2_mat=A.*ap2_mat.*kp2_mat.^alpha.*lp2_mat.^(1-alpha);
yp3_mat=A.*ap3_mat.*kp3_mat.^alpha.*lp3_mat.^(1-alpha);
yp4_mat=A.*ap4_mat.*kp4_mat.^alpha.*lp4_mat.^(1-alpha);
yp5_mat=A.*ap5_mat.*kp5_mat.^alpha.*lp5_mat.^(1-alpha);
yp6_mat=A.*ap6_mat.*kp6_mat.^alpha.*lp6_mat.^(1-alpha);
yp7_mat=A.*ap7_mat.*kp7_mat.^alpha.*lp7_mat.^(1-alpha);
yp8_mat=A.*ap8_mat.*kp8_mat.^alpha.*lp8_mat.^(1-alpha);
Yp_mat=yp1_mat+yp2_mat+yp3_mat+yp4_mat+yp5_mat+yp6_mat+yp7_mat+yp8_mat;


NN=size(REGp,1);
NN2=NN/18;

LHS1=c1_mat(1:NN2).^(-1/gamma(1)).*(1+phi.*(kp1_mat(1:NN2)./k1_mat(1:NN2)-1));   
LHS2=c2_mat(1:NN2).^(-1/gamma(2)).*(1+phi.*(kp2_mat(1:NN2)./k2_mat(1:NN2)-1));   
LHS3=c3_mat(1:NN2).^(-1/gamma(3)).*(1+phi.*(kp3_mat(1:NN2)./k3_mat(1:NN2)-1));   
LHS4=c4_mat(1:NN2).^(-1/gamma(4)).*(1+phi.*(kp4_mat(1:NN2)./k4_mat(1:NN2)-1));   
LHS5=c5_mat(1:NN2).^(-1/gamma(5)).*(1+phi.*(kp5_mat(1:NN2)./k5_mat(1:NN2)-1));   
LHS6=c6_mat(1:NN2).^(-1/gamma(6)).*(1+phi.*(kp6_mat(1:NN2)./k6_mat(1:NN2)-1));
LHS7=c7_mat(1:NN2).^(-1/gamma(7)).*(1+phi.*(kp7_mat(1:NN2)./k7_mat(1:NN2)-1));   
LHS8=c8_mat(1:NN2).^(-1/gamma(8)).*(1+phi.*(kp8_mat(1:NN2)./k8_mat(1:NN2)-1));     
LHS9=Y_mat(1:NN2)-CAC_mat(1:NN2);
        
RHS1=mean(reshape(beta*[cp1_mat.^(-1/gamma(1))].*[[1+phi*(1+1/2.*(kpp1_mat./kp1_mat-1)).*(kpp1_mat./kp1_mat-1)]+...
    A*ap1_mat.*alpha.*kp1_mat.^(alpha-1).*lp1_mat.^(1-alpha)],NN/18,18),2);
RHS2=mean(reshape(beta*[cp2_mat.^(-1/gamma(2))].*[[1+phi*(1+1/2.*(kpp2_mat./kp2_mat-1)).*(kpp2_mat./kp2_mat-1)]+...
    A*ap2_mat.*alpha.*kp2_mat.^(alpha-1).*lp2_mat.^(1-alpha)],NN/18,18),2);
RHS3=mean(reshape(beta*[cp3_mat.^(-1/gamma(3))].*[[1+phi*(1+1/2.*(kpp3_mat./kp3_mat-1)).*(kpp3_mat./kp3_mat-1)]+...
    A*ap3_mat.*alpha.*kp3_mat.^(alpha-1).*lp3_mat.^(1-alpha)],NN/18,18),2);
RHS4=mean(reshape(beta*[cp4_mat.^(-1/gamma(4))].*[[1+phi*(1+1/2.*(kpp4_mat./kp4_mat-1)).*(kpp4_mat./kp4_mat-1)]+...
    A*ap4_mat.*alpha.*kp4_mat.^(alpha-1).*lp4_mat.^(1-alpha)],NN/18,18),2);
RHS5=mean(reshape(beta*[cp5_mat.^(-1/gamma(5))].*[[1+phi*(1+1/2.*(kpp5_mat./kp5_mat-1)).*(kpp5_mat./kp5_mat-1)]+...
    A*ap5_mat.*alpha.*kp5_mat.^(alpha-1).*lp5_mat.^(1-alpha)],NN/18,18),2);
RHS6=mean(reshape(beta*[cp6_mat.^(-1/gamma(6))].*[[1+phi*(1+1/2.*(kpp6_mat./kp6_mat-1)).*(kpp6_mat./kp6_mat-1)]+...
    A*ap6_mat.*alpha.*kp6_mat.^(alpha-1).*lp6_mat.^(1-alpha)],NN/18,18),2);
RHS7=mean(reshape(beta*[cp7_mat.^(-1/gamma(7))].*[[1+phi*(1+1/2.*(kpp7_mat./kp7_mat-1)).*(kpp7_mat./kp7_mat-1)]+...
    A*ap7_mat.*alpha.*kp7_mat.^(alpha-1).*lp7_mat.^(1-alpha)],NN/18,18),2);
RHS8=mean(reshape(beta*[cp8_mat.^(-1/gamma(8))].*[[1+phi*(1+1/2.*(kpp8_mat./kp8_mat-1)).*(kpp8_mat./kp8_mat-1)]+...
    A*ap8_mat.*alpha.*kp8_mat.^(alpha-1).*lp8_mat.^(1-alpha)],NN/18,18),2);
RHS9=C_mat(1:NN2)+[Kp_mat(1:NN2)-K_mat(1:NN2)];
        
RES1=[LHS1-RHS1]./LHS1;
RES2=[LHS2-RHS2]./LHS2;
RES3=[LHS3-RHS3]./LHS3;
RES4=[LHS4-RHS4]./LHS4;
RES5=[LHS5-RHS5]./LHS5;
RES6=[LHS6-RHS6]./LHS6;
RES7=[LHS7-RHS7]./LHS7;
RES8=[LHS8-RHS8]./LHS8;
RES9=[LHS9-RHS9]./LHS9;

RESIDUALS=[RES1 RES2 RES3 RES4 RES5 RES6 RES7 RES8 RES9]; 

REG=REG_mat(1:NN2,:);
weights=[B0_MON;ones(4*N,1)*B1_MON;ones(length(RES1)-4*N-1,1)*B2_MON];
res=[REG'*(RES1.*weights);REG'*(RES2.*weights);REG'*(RES3.*weights);...
    REG'*(RES4.*weights);REG'*(RES5.*weights);REG'*(RES6.*weights);REG'*(RES7.*weights);...
    ;REG'*(RES8.*weights);REG'*(RES9.*weights)];
