global kmin kmax amin amax psi Le alpha A gamma
global regvec_labor1 regvec_labor2 regvec_labor3 regvec_labor4 regvec_labor5 regvec_labor6 mumin mumax

grid_points=20;

gr_points=grid_points-1;

mumin=0.9*muss;
mumax=1.1*muss;
MU_grid=[mumin:(mumax-mumin)./gr_points:mumax]';
A_grid=[amin:(amax-amin)./gr_points:amax]';
K_grid=[kmin:(kmax-kmin)./gr_points:kmax]';

MUAK_grid=zeros(grid_points^3,3);
MUAK_grid(:,1)=[kron(ones(grid_points^0,1),kron(MU_grid,ones(grid_points^2,1)))];
MUAK_grid(:,2)=[kron(ones(grid_points^1,1),kron(A_grid,ones(grid_points^1,1)))];
MUAK_grid(:,3)=[kron(ones(grid_points^2,1),kron(K_grid,ones(grid_points^0,1)))];

l_grid=zeros(size(MUAK_grid,1),6);

for i=1:length(l_grid);
    for j=1:6
       % disp([i j])
    l_grid(i,j)=fcsolve('labor_res',1,[10000;1e-14;1e-8;1e-3;0],[MUAK_grid(i,:) gamma(j) tau(j)]);
    end
end

REG_MU=chebpol(8,scaldown(MUAK_grid(:,1),mumin,mumax));
REG_A=chebpol(8,scaldown(MUAK_grid(:,2),amin,amax));
REG_K=chebpol(8,scaldown(MUAK_grid(:,3),kmin,kmax));

REGMAT=makepoly_MUAK(REG_MU,REG_A,REG_K);

regvec_labor1=REGMAT\l_grid(:,1);
regvec_labor2=REGMAT\l_grid(:,2);
regvec_labor3=REGMAT\l_grid(:,3);
regvec_labor4=REGMAT\l_grid(:,4);
regvec_labor5=REGMAT\l_grid(:,5);
regvec_labor6=REGMAT\l_grid(:,6);

% save regvec_labor.mat regvec_labor1 regvec_labor2 regvec_labor3 regvec_labor4 regvec_labor5 regvec_labor6 mumin mumax
