% Resiudal function containing the projection conditions

function res=projections_res(dr_coeff0);


global N beta alpha delta sigma rho phi A gamma tau ord
global kmin kmax amin amax
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat k3_mat k4_mat k5_mat k6_mat K_mat
global a1_mat a2_mat a3_mat a4_mat a5_mat a6_mat
global ap1_mat ap2_mat ap3_mat ap4_mat ap5_mat ap6_mat
global y1_mat y2_mat y3_mat y4_mat y5_mat y6_mat Y_mat
global cheby_ap1_mat cheby_ap2_mat cheby_ap3_mat
global cheby_ap4_mat cheby_ap5_mat cheby_ap6_mat
global regvec C_min C_max


% decompose coefficient vector
dr_k1=dr_coeff0(0*end/6+1:1*end/6);
dr_k2=dr_coeff0(1*end/6+1:2*end/6);
dr_k3=dr_coeff0(2*end/6+1:3*end/6);
dr_k4=dr_coeff0(3*end/6+1:4*end/6);
dr_k5=dr_coeff0(4*end/6+1:5*end/6);
dr_k6=dr_coeff0(5*end/6+1:6*end/6);

kp1_mat=REG_mat*dr_k1;
kp2_mat=REG_mat*dr_k2;
kp3_mat=REG_mat*dr_k3;
kp4_mat=REG_mat*dr_k4;
kp5_mat=REG_mat*dr_k5;
kp6_mat=REG_mat*dr_k6;
Kp_mat=kp1_mat+kp2_mat+kp3_mat+kp4_mat+kp5_mat+kp6_mat;

cac1_mat=phi/2*k1_mat.*(kp1_mat./k1_mat-1).^2;
cac2_mat=phi/2*k2_mat.*(kp2_mat./k2_mat-1).^2;
cac3_mat=phi/2*k3_mat.*(kp3_mat./k3_mat-1).^2;
cac4_mat=phi/2*k4_mat.*(kp4_mat./k4_mat-1).^2;
cac5_mat=phi/2*k5_mat.*(kp5_mat./k5_mat-1).^2;
cac6_mat=phi/2*k6_mat.*(kp6_mat./k6_mat-1).^2;
CAC_mat=cac1_mat+cac2_mat+cac3_mat+cac4_mat+cac5_mat+cac6_mat;

C_mat=Y_mat-[Kp_mat-K_mat]-CAC_mat;

REGCC=chebpol(8,scaldown(C_mat,C_min,C_max));

c1_mat=REGCC*regvec;
c2_mat=[tau(1)./tau(2)*c1_mat.^(-1/gamma(1))].^(-gamma(2));
c3_mat=[tau(1)./tau(3)*c1_mat.^(-1/gamma(1))].^(-gamma(3));
c4_mat=[tau(1)./tau(4)*c1_mat.^(-1/gamma(1))].^(-gamma(4));
c5_mat=[tau(1)./tau(5)*c1_mat.^(-1/gamma(1))].^(-gamma(5));
c6_mat=[tau(1)./tau(6)*c1_mat.^(-1/gamma(1))].^(-gamma(6));


% compute chebyshev polynomials from next period's endogenous
% states
cheby_kp1_mat=chebpol_2(ord,2*[kp1_mat-kmin]/[kmax-kmin]-1);
cheby_kp2_mat=chebpol_2(ord,2*[kp2_mat-kmin]/[kmax-kmin]-1);
cheby_kp3_mat=chebpol_2(ord,2*[kp3_mat-kmin]/[kmax-kmin]-1);
cheby_kp4_mat=chebpol_2(ord,2*[kp4_mat-kmin]/[kmax-kmin]-1);
cheby_kp5_mat=chebpol_2(ord,2*[kp5_mat-kmin]/[kmax-kmin]-1);
cheby_kp6_mat=chebpol_2(ord,2*[kp6_mat-kmin]/[kmax-kmin]-1);

REGp=makepoly_2_12(cheby_kp1_mat,cheby_kp2_mat,cheby_kp3_mat,cheby_kp4_mat,cheby_kp5_mat,cheby_kp6_mat,...
    cheby_ap1_mat,cheby_ap2_mat,cheby_ap3_mat,cheby_ap4_mat,cheby_ap5_mat,cheby_ap6_mat);

kpp1_mat=REGp*dr_k1;
kpp2_mat=REGp*dr_k2;
kpp3_mat=REGp*dr_k3;
kpp4_mat=REGp*dr_k4;
kpp5_mat=REGp*dr_k5;
kpp6_mat=REGp*dr_k6;
Kpp_mat=kpp1_mat+kpp2_mat+kpp3_mat+kpp4_mat+kpp5_mat+kpp6_mat;

% compute output levels
yp1_mat=A.*ap1_mat.*kp1_mat.^alpha;
yp2_mat=A.*ap2_mat.*kp2_mat.^alpha;
yp3_mat=A.*ap3_mat.*kp3_mat.^alpha;
yp4_mat=A.*ap4_mat.*kp4_mat.^alpha;
yp5_mat=A.*ap5_mat.*kp5_mat.^alpha;
yp6_mat=A.*ap6_mat.*kp6_mat.^alpha;
Yp_mat=yp1_mat+yp2_mat+yp3_mat+yp4_mat+yp5_mat+yp6_mat;

cacp1_mat=phi/2*kp1_mat.*(kpp1_mat./kp1_mat-1).^2;
cacp2_mat=phi/2*kp2_mat.*(kpp2_mat./kp2_mat-1).^2;
cacp3_mat=phi/2*kp3_mat.*(kpp3_mat./kp3_mat-1).^2;
cacp4_mat=phi/2*kp4_mat.*(kpp4_mat./kp4_mat-1).^2;
cacp5_mat=phi/2*kp5_mat.*(kpp5_mat./kp5_mat-1).^2;
cacp6_mat=phi/2*kp6_mat.*(kpp6_mat./kp6_mat-1).^2;
CACp_mat=cacp1_mat+cacp2_mat+cacp3_mat+cacp4_mat+cacp5_mat+cacp6_mat;

Cp_mat=Yp_mat-[Kpp_mat-Kp_mat]-CACp_mat;

REGCC_P=chebpol(8,scaldown(Cp_mat,C_min,C_max));

cp1_mat=REGCC_P*regvec;   
cp2_mat=[tau(1)./tau(2)*cp1_mat.^(-1/gamma(1))].^(-gamma(2));
cp3_mat=[tau(1)./tau(3)*cp1_mat.^(-1/gamma(1))].^(-gamma(3));
cp4_mat=[tau(1)./tau(4)*cp1_mat.^(-1/gamma(1))].^(-gamma(4));
cp5_mat=[tau(1)./tau(5)*cp1_mat.^(-1/gamma(1))].^(-gamma(5));
cp6_mat=[tau(1)./tau(6)*cp1_mat.^(-1/gamma(1))].^(-gamma(6));
%C_mat=c1_mat+c2_mat+c3_mat+c4_mat+c5_mat+c6_mat;


NN=size(REGp,1);
NN2=NN/14;

LHS1=c1_mat(1:NN2).^(-1/gamma(1)).*(1+phi.*(kp1_mat(1:NN2)./k1_mat(1:NN2)-1));   
LHS2=c2_mat(1:NN2).^(-1/gamma(2)).*(1+phi.*(kp2_mat(1:NN2)./k2_mat(1:NN2)-1));   
LHS3=c3_mat(1:NN2).^(-1/gamma(3)).*(1+phi.*(kp3_mat(1:NN2)./k3_mat(1:NN2)-1));   
LHS4=c4_mat(1:NN2).^(-1/gamma(4)).*(1+phi.*(kp4_mat(1:NN2)./k4_mat(1:NN2)-1));   
LHS5=c5_mat(1:NN2).^(-1/gamma(5)).*(1+phi.*(kp5_mat(1:NN2)./k5_mat(1:NN2)-1));   
LHS6=c6_mat(1:NN2).^(-1/gamma(6)).*(1+phi.*(kp6_mat(1:NN2)./k6_mat(1:NN2)-1));   

        
RHS1=mean(reshape(beta*[cp1_mat.^(-1/gamma(1))].*[[1+phi*(1+1/2.*(kpp1_mat./kp1_mat-1)).*(kpp1_mat./kp1_mat-1)]+...
    A*ap1_mat.*alpha.*kp1_mat.^(alpha-1)],NN/14,14),2);
RHS2=mean(reshape(beta*[cp2_mat.^(-1/gamma(2))].*[[1+phi*(1+1/2.*(kpp2_mat./kp2_mat-1)).*(kpp2_mat./kp2_mat-1)]+...
    A*ap2_mat.*alpha.*kp2_mat.^(alpha-1)],NN/14,14),2);
RHS3=mean(reshape(beta*[cp3_mat.^(-1/gamma(3))].*[[1+phi*(1+1/2.*(kpp3_mat./kp3_mat-1)).*(kpp3_mat./kp3_mat-1)]+...
    A*ap3_mat.*alpha.*kp3_mat.^(alpha-1)],NN/14,14),2);
RHS4=mean(reshape(beta*[cp4_mat.^(-1/gamma(4))].*[[1+phi*(1+1/2.*(kpp4_mat./kp4_mat-1)).*(kpp4_mat./kp4_mat-1)]+...
    A*ap4_mat.*alpha.*kp4_mat.^(alpha-1)],NN/14,14),2);
RHS5=mean(reshape(beta*[cp5_mat.^(-1/gamma(5))].*[[1+phi*(1+1/2.*(kpp5_mat./kp5_mat-1)).*(kpp5_mat./kp5_mat-1)]+...
    A*ap5_mat.*alpha.*kp5_mat.^(alpha-1)],NN/14,14),2);
RHS6=mean(reshape(beta*[cp6_mat.^(-1/gamma(6))].*[[1+phi*(1+1/2.*(kpp6_mat./kp6_mat-1)).*(kpp6_mat./kp6_mat-1)]+...
    A*ap6_mat.*alpha.*kp6_mat.^(alpha-1)],NN/14,14),2);

        
RES1=[LHS1-RHS1]./LHS1;
RES2=[LHS2-RHS2]./LHS2;
RES3=[LHS3-RHS3]./LHS3;
RES4=[LHS4-RHS4]./LHS4;
RES5=[LHS5-RHS5]./LHS5;
RES6=[LHS6-RHS6]./LHS6;


RESIDUALS=[RES1 RES2 RES3 RES4 RES5 RES6]; 

REG=REG_mat(1:NN2,:);
weights=[B0_MON;ones(4*N,1)*B1_MON;ones(length(RES1)-4*N-1,1)*B2_MON];
res=[REG'*(RES1.*weights);REG'*(RES2.*weights);REG'*(RES3.*weights);...
    REG'*(RES4.*weights);REG'*(RES5.*weights);REG'*(RES6.*weights)];
%disp(sum(abs(res)));