% Resiudal function containing the projection conditions

function res=projections_res(dr_coeff0);


global N beta alpha delta sigma rho phi A gamma tau ord psi Le
global kmin kmax amin amax 
global nodes xgrid REG_mat B0_MON B1_MON B2_MON RESIDUALS
global k1_mat k2_mat k3_mat k4_mat  K_mat
global a1_mat a2_mat a3_mat a4_mat 
global ap1_mat ap2_mat ap3_mat ap4_mat
global cheby_ap1_mat cheby_ap2_mat cheby_ap3_mat
global cheby_ap4_mat 
global regvec_labor1 regvec_labor2 regvec_labor3 regvec_labor4 mumin mumax



% decompose coefficient vector
dr_k1=dr_coeff0(0*end/5+1:1*end/5);
dr_k2=dr_coeff0(1*end/5+1:2*end/5);
dr_k3=dr_coeff0(2*end/5+1:3*end/5);
dr_k4=dr_coeff0(3*end/5+1:4*end/5);
dr_mu=dr_coeff0(4*end/5+1:5*end/5);

kp1_mat=REG_mat*dr_k1;
kp2_mat=REG_mat*dr_k2;
kp3_mat=REG_mat*dr_k3;
kp4_mat=REG_mat*dr_k4;
Kp_mat=kp1_mat+kp2_mat+kp3_mat+kp4_mat;

cac1_mat=phi/2*k1_mat.*(kp1_mat./k1_mat-1).^2;
cac2_mat=phi/2*k2_mat.*(kp2_mat./k2_mat-1).^2;
cac3_mat=phi/2*k3_mat.*(kp3_mat./k3_mat-1).^2;
cac4_mat=phi/2*k4_mat.*(kp4_mat./k4_mat-1).^2;
CAC_mat=cac1_mat+cac2_mat+cac3_mat+cac4_mat;

mu_mat=exp(REG_mat*dr_mu);

REG_MU=chebpol(8,scaldown(mu_mat,mumin,mumax));

REG_A1=chebpol(8,scaldown(a1_mat,amin,amax));
REG_A2=chebpol(8,scaldown(a2_mat,amin,amax));
REG_A3=chebpol(8,scaldown(a3_mat,amin,amax));
REG_A4=chebpol(8,scaldown(a4_mat,amin,amax));

REG_K1=chebpol(8,scaldown(k1_mat,kmin,kmax));
REG_K2=chebpol(8,scaldown(k2_mat,kmin,kmax));
REG_K3=chebpol(8,scaldown(k3_mat,kmin,kmax));
REG_K4=chebpol(8,scaldown(k4_mat,kmin,kmax));

REGMAT1=makepoly_MUAK(REG_MU,REG_A1,REG_K1);
REGMAT2=makepoly_MUAK(REG_MU,REG_A2,REG_K2);
REGMAT3=makepoly_MUAK(REG_MU,REG_A3,REG_K3);
REGMAT4=makepoly_MUAK(REG_MU,REG_A4,REG_K4);

l1_mat=REGMAT1*regvec_labor1;
l2_mat=REGMAT2*regvec_labor2;
l3_mat=REGMAT3*regvec_labor3;
l4_mat=REGMAT4*regvec_labor4;

c1_mat=[psi/(1-psi)].*(Le-l1_mat).*a1_mat.*(1-alpha).*A.*k1_mat.^alpha.*l1_mat.^(-alpha);
c2_mat=[psi/(1-psi)].*(Le-l2_mat).*a2_mat.*(1-alpha).*A.*k2_mat.^alpha.*l2_mat.^(-alpha);
c3_mat=[psi/(1-psi)].*(Le-l3_mat).*a3_mat.*(1-alpha).*A.*k3_mat.^alpha.*l3_mat.^(-alpha);
c4_mat=[psi/(1-psi)].*(Le-l4_mat).*a4_mat.*(1-alpha).*A.*k4_mat.^alpha.*l4_mat.^(-alpha);
C_mat=c1_mat+c2_mat+c3_mat+c4_mat;

mu1_mat=[tau(1)*psi*[[c1_mat.^psi.*(Le-l1_mat).^(1-psi)].^(1-1/gamma(1))]./c1_mat];
mu2_mat=[tau(2)*psi*[[c2_mat.^psi.*(Le-l2_mat).^(1-psi)].^(1-1/gamma(2))]./c2_mat];
mu3_mat=[tau(3)*psi*[[c3_mat.^psi.*(Le-l3_mat).^(1-psi)].^(1-1/gamma(3))]./c3_mat];
mu4_mat=[tau(4)*psi*[[c4_mat.^psi.*(Le-l4_mat).^(1-psi)].^(1-1/gamma(4))]./c4_mat];

% compute output levels
y1_mat=A.*a1_mat.*k1_mat.^alpha.*l1_mat.^(1-alpha);
y2_mat=A.*a2_mat.*k2_mat.^alpha.*l2_mat.^(1-alpha);
y3_mat=A.*a3_mat.*k3_mat.^alpha.*l3_mat.^(1-alpha);
y4_mat=A.*a4_mat.*k4_mat.^alpha.*l4_mat.^(1-alpha);
Y_mat=y1_mat+y2_mat+y3_mat+y4_mat;

% compute chebyshev polynomials from next period's endogenous
% states
cheby_kp1_mat=chebpol_2(ord,2*[kp1_mat-kmin]/[kmax-kmin]-1);
cheby_kp2_mat=chebpol_2(ord,2*[kp2_mat-kmin]/[kmax-kmin]-1);
cheby_kp3_mat=chebpol_2(ord,2*[kp3_mat-kmin]/[kmax-kmin]-1);
cheby_kp4_mat=chebpol_2(ord,2*[kp4_mat-kmin]/[kmax-kmin]-1);

REGp=makepoly_2_8(cheby_kp1_mat,cheby_kp2_mat,cheby_kp3_mat,cheby_kp4_mat,...
    cheby_ap1_mat,cheby_ap2_mat,cheby_ap3_mat,cheby_ap4_mat);

kpp1_mat=REGp*dr_k1;
kpp2_mat=REGp*dr_k2;
kpp3_mat=REGp*dr_k3;
kpp4_mat=REGp*dr_k4;
Kpp_mat=kpp1_mat+kpp2_mat+kpp3_mat+kpp4_mat;

cacp1_mat=phi/2*kp1_mat.*(kpp1_mat./kp1_mat-1).^2;
cacp2_mat=phi/2*kp2_mat.*(kpp2_mat./kp2_mat-1).^2;
cacp3_mat=phi/2*kp3_mat.*(kpp3_mat./kp3_mat-1).^2;
cacp4_mat=phi/2*kp4_mat.*(kpp4_mat./kp4_mat-1).^2;
CACp_mat=cacp1_mat+cacp2_mat+cacp3_mat+cacp4_mat;

mup_mat=exp(REGp*dr_mu);

REG_MUp=chebpol(8,scaldown(mup_mat,mumin,mumax));

REG_Ap1=chebpol(8,scaldown(ap1_mat,amin,amax));
REG_Ap2=chebpol(8,scaldown(ap2_mat,amin,amax));
REG_Ap3=chebpol(8,scaldown(ap3_mat,amin,amax));
REG_Ap4=chebpol(8,scaldown(ap4_mat,amin,amax));

REG_Kp1=chebpol(8,scaldown(kp1_mat,kmin,kmax));
REG_Kp2=chebpol(8,scaldown(kp2_mat,kmin,kmax));
REG_Kp3=chebpol(8,scaldown(kp3_mat,kmin,kmax));
REG_Kp4=chebpol(8,scaldown(kp4_mat,kmin,kmax));

REGMATp1=makepoly_MUAK(REG_MUp,REG_Ap1,REG_Kp1);
REGMATp2=makepoly_MUAK(REG_MUp,REG_Ap2,REG_Kp2);
REGMATp3=makepoly_MUAK(REG_MUp,REG_Ap3,REG_Kp3);
REGMATp4=makepoly_MUAK(REG_MUp,REG_Ap4,REG_Kp4);

lp1_mat=REGMATp1*regvec_labor1;
lp2_mat=REGMATp2*regvec_labor2;
lp3_mat=REGMATp3*regvec_labor3;
lp4_mat=REGMATp4*regvec_labor4;

cp1_mat=[psi/(1-psi)].*(Le-lp1_mat).*ap1_mat.*(1-alpha).*A.*kp1_mat.^alpha.*lp1_mat.^(-alpha);
cp2_mat=[psi/(1-psi)].*(Le-lp2_mat).*ap2_mat.*(1-alpha).*A.*kp2_mat.^alpha.*lp2_mat.^(-alpha);
cp3_mat=[psi/(1-psi)].*(Le-lp3_mat).*ap3_mat.*(1-alpha).*A.*kp3_mat.^alpha.*lp3_mat.^(-alpha);
cp4_mat=[psi/(1-psi)].*(Le-lp4_mat).*ap4_mat.*(1-alpha).*A.*kp4_mat.^alpha.*lp4_mat.^(-alpha);
Cp_mat=cp1_mat+cp2_mat+cp3_mat+cp4_mat;

% compute output levels
yp1_mat=A.*ap1_mat.*kp1_mat.^alpha.*lp1_mat.^(1-alpha);
yp2_mat=A.*ap2_mat.*kp2_mat.^alpha.*lp2_mat.^(1-alpha);;
yp3_mat=A.*ap3_mat.*kp3_mat.^alpha.*lp3_mat.^(1-alpha);;
yp4_mat=A.*ap4_mat.*kp4_mat.^alpha.*lp4_mat.^(1-alpha);;
Yp_mat=yp1_mat+yp2_mat+yp3_mat+yp4_mat;


NN=size(REGp,1);
NN2=NN/10;

LHS1=[tau(1)*psi*[[c1_mat(1:NN2).^psi.*(Le-l1_mat(1:NN2)).^(1-psi)].^(1-1/gamma(1))]./c1_mat(1:NN2)].*(1+phi.*(kp1_mat(1:NN2)./k1_mat(1:NN2)-1));   
LHS2=[tau(2)*psi*[[c2_mat(1:NN2).^psi.*(Le-l2_mat(1:NN2)).^(1-psi)].^(1-1/gamma(2))]./c2_mat(1:NN2)].*(1+phi.*(kp2_mat(1:NN2)./k2_mat(1:NN2)-1)); 
LHS3=[tau(3)*psi*[[c3_mat(1:NN2).^psi.*(Le-l3_mat(1:NN2)).^(1-psi)].^(1-1/gamma(3))]./c3_mat(1:NN2)].*(1+phi.*(kp3_mat(1:NN2)./k3_mat(1:NN2)-1));
LHS4=[tau(4)*psi*[[c4_mat(1:NN2).^psi.*(Le-l4_mat(1:NN2)).^(1-psi)].^(1-1/gamma(4))]./c4_mat(1:NN2)].*(1+phi.*(kp4_mat(1:NN2)./k4_mat(1:NN2)-1));
LHS5=Y_mat(1:NN2);

        
RHS1=mean(reshape(beta*[tau(1)*psi*[[cp1_mat.^psi.*(Le-lp1_mat).^(1-psi)].^(1-1/gamma(1))]./cp1_mat].*...
    [[1+phi*(1+1/2.*(kpp1_mat./kp1_mat-1)).*(kpp1_mat./kp1_mat-1)]+...
    A*ap1_mat.*alpha.*kp1_mat.^(alpha-1).*lp1_mat.^(1-alpha)],NN/10,10),2);
RHS2=mean(reshape(beta*[tau(2)*psi*[[cp2_mat.^psi.*(Le-lp2_mat).^(1-psi)].^(1-1/gamma(2))]./cp2_mat].*...
    [[1+phi*(1+1/2.*(kpp2_mat./kp2_mat-1)).*(kpp2_mat./kp2_mat-1)]+...
    A*ap2_mat.*alpha.*kp2_mat.^(alpha-1).*lp2_mat.^(1-alpha)],NN/10,10),2);
RHS3=mean(reshape(beta*[tau(3)*psi*[[cp3_mat.^psi.*(Le-lp3_mat).^(1-psi)].^(1-1/gamma(3))]./cp3_mat].*...
    [[1+phi*(1+1/2.*(kpp3_mat./kp3_mat-1)).*(kpp3_mat./kp3_mat-1)]+...
    A*ap3_mat.*alpha.*kp3_mat.^(alpha-1).*lp3_mat.^(1-alpha)],NN/10,10),2);
RHS4=mean(reshape(beta*[tau(4)*psi*[[cp4_mat.^psi.*(Le-lp4_mat).^(1-psi)].^(1-1/gamma(4))]./cp4_mat].*...
    [[1+phi*(1+1/2.*(kpp4_mat./kp4_mat-1)).*(kpp4_mat./kp4_mat-1)]+...
    A*ap4_mat.*alpha.*kp4_mat.^(alpha-1).*lp4_mat.^(1-alpha)],NN/10,10),2);
RHS5=C_mat(1:NN2)+[Kp_mat(1:NN2)-K_mat(1:NN2)]+CAC_mat(1:NN2);
        
RES1=[LHS1-RHS1]./LHS1;
RES2=[LHS2-RHS2]./LHS2;
RES3=[LHS3-RHS3]./LHS3;
RES4=[LHS4-RHS4]./LHS4;
RES5=[LHS5-RHS5]./LHS5;



RESIDUALS=[RES1 RES2 RES3 RES4 RES5]; 

REG=REG_mat(1:NN2,:);
weights=[B0_MON;ones(4*N,1)*B1_MON;ones(length(RES1)-4*N-1,1)*B2_MON];
res=[REG'*(RES1.*weights);REG'*(RES2.*weights);REG'*(RES3.*weights);...
    REG'*(RES4.*weights);REG'*(RES5.*weights)];
%disp(mean(mean(abs(RESIDUALS))));