

function res=jedcS7_POLF_A(z,HH0,HH1,HH2);
% 7.10.2007  Henry Kim, Jinill Kim, Robert Kollmann
% Policy function for jedc Problem A
% z=[k(t);theta(t)]; 
% k(t): NCx1 vector of capital stocks of NC countries at end of period t
% theta(t): NCx1 vector of countries' date t productivities 
% The proc takes z(t) and computes vector of date t choice variables, w:
%  w=jedcS7_POLF_A(z,...);
% w=[c(t); Lab(t); LAMBDA(t); k(t+1); iv(t)];
% c(t), Lab(t), iv(t), theta(t): NCx1 vector of countries' consumption, labor
%   supply, investment and productivity at date t
% LAMBDA(t): maginal utility at t (scalar)
% k(t+1): NCx1 vector of capital stocks at end of t
% HH0, HH1, HH2: coefficients of Taylor expansion of policy function
% w(i)=HH0(i,:)+HH1(i,:)*z+.5*z'*squeeze(HH2(i,:,:))*z

% Example: k=randn(NC,1); th=randn(NC,1); w=jedcS7_POLF_A([k;th],HH0,HH1,HH2);

% ATTENTION: z and w ARE EXPRESSED AS DIFFERENCES FROM STEADY STATE

% checking dimensions
k0=size(HH0); k1=size(HH1); k2=size(HH2);
if abs(k0(1,:)-k1(1,:))+abs(k0(:,1)-k2(:,1))~=0; error('E1'); end;
if k0(:,2)~=1; error('E2'); end;
if k1(:,1)~=4*(k1(:,2)/2)+1; error('E3'); end;
if k2(:,1)~=4*(k2(:,2)/2)+1; error('E4'); end;
if k2(:,2)~=k1(:,2); error('E5'); end;
if k2(:,3)~=k2(:,2); error('E6'); end;

N=k1(:,2)/2; % number of countries

if cols(size(z))>2; error('F1'); end;
if cols(z)>2; error('F2'); end;
if rows(z)~=2*N; error('F3'); end;

res2=[];
j=1; while j<=rows(HH2);
res2=[res2; z'*squeeze(HH2(j,:,:))*z];
j=j+1; end;

res=HH0+HH1*z+.5*res2;

% [HH0  HH1*z  .5*res2]

