% Decision rules for model A5 with N=10 countries

% Input:    state variables at time t (capital stocks and technology levels)
% Output:   decision variables: dv=[c;l;kp;i;lambda];
%               c:  Nx1 vector of consumption levels
%               l:  Nx1 vector of labor supplies
%               kp: Nx1 vector of next period capital stocks
%               i:  Nx1 vector of investment
%               lambda:  marginal utility of consumption
            
% Note: Model A1 features inelastic labor supply equal to one

function dv=policies_A5N10(states,dr_coeff_A5N10,kmin,kmax,amin,amax,C_min,C_max,regvec)

k1=states(1);
k2=states(2);
k3=states(3);
k4=states(4);
k5=states(5);
k6=states(6);
k7=states(7);
k8=states(8);
k9=states(9);
k10=states(10);

a1=states(11);
a2=states(12);
a3=states(13);
a4=states(14);
a5=states(15);
a6=states(16);
a7=states(17);
a8=states(18);
a9=states(18);
a10=states(20);

dr_k1=dr_coeff_A5N10(0*end/10+1:1*end/10);
dr_k2=dr_coeff_A5N10(1*end/10+1:2*end/10);
dr_k3=dr_coeff_A5N10(2*end/10+1:3*end/10);
dr_k4=dr_coeff_A5N10(3*end/10+1:4*end/10);
dr_k5=dr_coeff_A5N10(4*end/10+1:5*end/10);
dr_k6=dr_coeff_A5N10(5*end/10+1:6*end/10);
dr_k7=dr_coeff_A5N10(6*end/10+1:7*end/10);
dr_k8=dr_coeff_A5N10(7*end/10+1:8*end/10);
dr_k9=dr_coeff_A5N10(8*end/10+1:9*end/10);
dr_k10=dr_coeff_A5N10(9*end/10+1:10*end/10);

% 1) Calibration
N=10;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);
gammalow=0.25;
gammahigh=1;
gamma=[gammalow:(gammahigh-gammalow)/(N-1):gammahigh];


% 2) Compute the steady state and the Negishi weights
kss=1;
Kss=N*kss;
css=A*kss^alpha;
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=N*A*kss^alpha;


% 3) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=css^(1/gamma(j));
end
muss=1;

% 4) Scale down states to interval [-1,1] and create Chebyshev polynomials;

sd_k1=2*(k1-kmin)/(kmax-kmin)-1;
sd_k2=2*(k2-kmin)/(kmax-kmin)-1;
sd_k3=2*(k3-kmin)/(kmax-kmin)-1;
sd_k4=2*(k4-kmin)/(kmax-kmin)-1;
sd_k5=2*(k5-kmin)/(kmax-kmin)-1;
sd_k6=2*(k6-kmin)/(kmax-kmin)-1;
sd_k7=2*(k7-kmin)/(kmax-kmin)-1;
sd_k8=2*(k8-kmin)/(kmax-kmin)-1;
sd_k9=2*(k9-kmin)/(kmax-kmin)-1;
sd_k10=2*(k10-kmin)/(kmax-kmin)-1;

sd_a1=2*(a1-amin)/(amax-amin)-1;
sd_a2=2*(a2-amin)/(amax-amin)-1;
sd_a3=2*(a3-amin)/(amax-amin)-1;
sd_a4=2*(a4-amin)/(amax-amin)-1;
sd_a5=2*(a5-amin)/(amax-amin)-1;
sd_a6=2*(a6-amin)/(amax-amin)-1;
sd_a7=2*(a7-amin)/(amax-amin)-1;
sd_a8=2*(a8-amin)/(amax-amin)-1;
sd_a9=2*(a9-amin)/(amax-amin)-1;
sd_a10=2*(a10-amin)/(amax-amin)-1;

Cheby_k1=[1 sd_k1 2*(sd_k1^2)-1];
Cheby_k2=[1 sd_k2 2*(sd_k2^2)-1];
Cheby_k3=[1 sd_k3 2*(sd_k3^2)-1];
Cheby_k4=[1 sd_k4 2*(sd_k4^2)-1];
Cheby_k5=[1 sd_k5 2*(sd_k5^2)-1];
Cheby_k6=[1 sd_k6 2*(sd_k6^2)-1];
Cheby_k7=[1 sd_k7 2*(sd_k7^2)-1];
Cheby_k8=[1 sd_k8 2*(sd_k8^2)-1];
Cheby_k9=[1 sd_k9 2*(sd_k9^2)-1];
Cheby_k10=[1 sd_k10 2*(sd_k10^2)-1];

Cheby_a1=[1 sd_a1 2*(sd_a1^2)-1];
Cheby_a2=[1 sd_a2 2*(sd_a2^2)-1];
Cheby_a3=[1 sd_a3 2*(sd_a3^2)-1];
Cheby_a4=[1 sd_a4 2*(sd_a4^2)-1];
Cheby_a5=[1 sd_a5 2*(sd_a5^2)-1];
Cheby_a6=[1 sd_a6 2*(sd_a6^2)-1];
Cheby_a7=[1 sd_a7 2*(sd_a7^2)-1];
Cheby_a8=[1 sd_a8 2*(sd_a8^2)-1];
Cheby_a9=[1 sd_a9 2*(sd_a9^2)-1];
Cheby_a10=[1 sd_a10 2*(sd_a10^2)-1];

% 5) Create complete polynomial matrix 
NoSt=2*N;
X1=Cheby_k1;
X2=Cheby_k2;
X3=Cheby_k3;
X4=Cheby_k4;
X5=Cheby_k5;
X6=Cheby_k6;
X7=Cheby_k7;
X8=Cheby_k8;
X9=Cheby_k9;
X10=Cheby_k10;

X11=Cheby_a1;
X12=Cheby_a2;
X13=Cheby_a3;
X14=Cheby_a4;
X15=Cheby_a5;
X16=Cheby_a6;
X17=Cheby_a7;
X18=Cheby_a8;
X19=Cheby_a9;
X20=Cheby_a10;

REG=zeros(size(X1,1),1+NoSt+(NoSt-1)*NoSt/2+NoSt);
jjj=1;
REG(:,jjj)=ones(size(X1,1),1);
for i=1:NoSt
    jjj=jjj+1;
    XX=eval(['X' num2str(i)]);
    REG(:,jjj)=XX(:,2);
end
for j=1:(NoSt-1)
    for i=(j+1):NoSt
        jjj=jjj+1;
        XXj=eval(['X' num2str(j)]);
        XXi=eval(['X' num2str(i)]);
        REG(:,jjj)=XXj(:,2).*XXi(:,2);
    end
end
for i=1:NoSt
    jjj=jjj+1;
    XX=eval(['X' num2str(i)]);
    REG(:,jjj)=XX(:,3);
end

% 6) Compute decision variables
    
    % Next period's capital stocks
    kp1=REG*dr_k1;
    kp2=REG*dr_k2;
    kp3=REG*dr_k3;
    kp4=REG*dr_k4;
    kp5=REG*dr_k5;
    kp6=REG*dr_k6;
    kp7=REG*dr_k7;
    kp8=REG*dr_k8;    
    kp9=REG*dr_k9;
    kp10=REG*dr_k10;
    
    kp_vec=[kp1;kp2;kp3;kp4;kp5;kp6;kp7;kp8;kp9;kp10];
    Kp=kp1+kp2+kp3+kp4+kp5+kp6+kp7+kp8+kp9+kp10;
    K=k1+k2+k3+k4+k5+k6+k7+k8+k9+k10;
    
    % Investment
    i1=kp1-(1-delta)*k1;
    i2=kp2-(1-delta)*k2;
    i3=kp3-(1-delta)*k3;
    i4=kp4-(1-delta)*k4;   
    i5=kp5-(1-delta)*k5;
    i6=kp6-(1-delta)*k6;  
    i7=kp7-(1-delta)*k7;
    i8=kp8-(1-delta)*k8;  
    i9=kp9-(1-delta)*k9;
    i10=kp10-(1-delta)*k10; 
    i_vec=[i1;i2;i3;i4;i5;i6;i7;i8;i9;i10];
    
    % Production
    y1=A.*a1.*k1.^alpha;
    y2=A.*a2.*k2.^alpha;    
    y3=A.*a3.*k3.^alpha;
    y4=A.*a4.*k4.^alpha;
    y5=A.*a5.*k5.^alpha;
    y6=A.*a6.*k6.^alpha;
    y7=A.*a7.*k7.^alpha;
    y8=A.*a8.*k8.^alpha;
    y9=A.*a9.*k9.^alpha;
    y10=A.*a10.*k10.^alpha;
    Y=y1+y2+y3+y4+y5+y6+y7+y8+y9+y10;
    
    % Capital adjustment costs
    cac1=phi/2*k1.*(kp1./k1-1).^2;
    cac2=phi/2*k2.*(kp2./k2-1).^2;
    cac3=phi/2*k3.*(kp3./k3-1).^2;
    cac4=phi/2*k4.*(kp4./k4-1).^2;
    cac5=phi/2*k5.*(kp5./k5-1).^2;
    cac6=phi/2*k6.*(kp6./k6-1).^2;
    cac7=phi/2*k7.*(kp7./k7-1).^2;
    cac8=phi/2*k8.*(kp8./k8-1).^2;
    cac9=phi/2*k9.*(kp9./k9-1).^2;
    cac10=phi/2*k10.*(kp10./k10-1).^2;
    CAC=cac1+cac2+cac3+cac4+cac5+cac6+cac7+cac8+cac9+cac10;   
    
    % Aggregate consumption
    C=Y-[Kp-K]-CAC;
        
    % Individual consumption 
    % Note: C_min,C_max, and regvec obtain as part of the SGG model
    %       solution; Avoiding non-linear equations solving 
    %       substantially reduces computing times
    
    % Construct complete Chebyshev polynomial matrix to be used for solving
   % for indicudual consumption of country 1
    sd_C=2*(C-C_min)/(C_max-C_min)-1;
    ord=8;
    REGC=ones(1,9);	
    REGC(:,2)=sd_C;
      for i	= 3:9;
            REGC(:,i)	= 2.*sd_C.*REGC(:,i-1)-REGC(:,i-2);
      end;
    c1=REGC*regvec; 
    c2=[tau(1)./tau(2)*c1.^(-1/gamma(1))].^(-gamma(2));
    c3=[tau(1)./tau(3)*c1.^(-1/gamma(1))].^(-gamma(3));
    c4=[tau(1)./tau(4)*c1.^(-1/gamma(1))].^(-gamma(4));
    c5=[tau(1)./tau(5)*c1.^(-1/gamma(1))].^(-gamma(5));
    c6=[tau(1)./tau(6)*c1.^(-1/gamma(1))].^(-gamma(6));
    c7=[tau(1)./tau(7)*c1.^(-1/gamma(1))].^(-gamma(7));
    c8=[tau(1)./tau(8)*c1.^(-1/gamma(1))].^(-gamma(8));
    c9=[tau(1)./tau(9)*c1.^(-1/gamma(1))].^(-gamma(9));
    c10=[tau(1)./tau(10)*c1.^(-1/gamma(1))].^(-gamma(10));
    c_vec=[c1;c2;c3;c4;c5;c6;c7;c8;c9;c10];
      
    % Labor    
    l1=1;
    l2=1;
    l3=1;
    l4=1;
    l5=1;
    l6=1;
    l7=1;
    l8=1;
    l9=1;
    l10=1;
    l_vec=[l1;l2;l3;l4;l5;l6;l7;l8;l9;l10];
    
    % Marginal utility of consumption (of first country)
    lambda=tau(1)*c1^(-1/gamma(1));
    
% 7) Create output
dv=[c_vec;l_vec;kp_vec;i_vec;lambda];