% Decision rules for model A4 with N=6 countries

% Input:    state variables at time t (capital stocks and technology levels)
% Output:   decision variables: dv=[c;l;kp;i;lambda];
%               c:  Nx1 vector of consumption levels
%               l:  Nx1 vector of labor supplies
%               kp: Nx1 vector of next period capital stocks
%               i:  Nx1 vector of investment
%               lambda:  marginal utility of consumption
            
% Note: Model A1 features inelastic labor supply equal to one

function dv=policies_A4N6(states,dr_coeff_A4N6,kmin,kmax,amin,amax,mumin,mumax,regvec_labor)

k1=states(1);
k2=states(2);
k3=states(3);
k4=states(4);
k5=states(5);
k6=states(6);

a1=states(7);
a2=states(8);
a3=states(9);
a4=states(10);
a5=states(11);
a6=states(12);

dr_k1=dr_coeff_A4N6(0*end/7+1:1*end/7);
dr_k2=dr_coeff_A4N6(1*end/7+1:2*end/7);
dr_k3=dr_coeff_A4N6(2*end/7+1:3*end/7);
dr_k4=dr_coeff_A4N6(3*end/7+1:4*end/7);
dr_k5=dr_coeff_A4N6(4*end/7+1:5*end/7);
dr_k6=dr_coeff_A4N6(5*end/7+1:6*end/7);
dr_mu=dr_coeff_A4N6(6*end/7+1:7*end/7);

% 1) Calibration
N=6;
beta=0.99;
alpha=0.36;
delta=0.025;
sigma=0.01;
rho=0.95;
phi=0.5;
A=(1-beta)/(alpha*beta);
gamma=ones(1,N)*0.25;
chi=ones(1,N)*0.83;
mupar=ones(1,N)*-0.2;
Le=2.5;


% 2) Compute the steady state and the Negishi weights
kss=1;
lss=1;
Kss=N*kss;
Lss=N*lss;
css=A*kss^alpha*lss^(1-alpha);
Css=N*css;
lnass=0;
ass=1;
thetass=1;
Yss=N*A;

b=zeros(1,N);
for j=1:N
    b(j)=(1-alpha)*A^(1-1/chi(j))/[(Le-lss)^(-1/chi(j))];
end


% b) Compute Negishi weights
tau=zeros(1,N);
for j=1:N
    tau(j)=[css^(-1/chi(j))*[css^(1-1/chi(j))+b(j)*(Le-lss)^(1-1/chi(j))]^[(1-1/gamma(j))/(1-1/chi(j))-1]]^(-1);
end
muss=1;

% 4) Scale down states to interval [-1,1] and create Chebyshev polynomials
sd_k1=2*(k1-kmin)/(kmax-kmin)-1;
sd_k2=2*(k2-kmin)/(kmax-kmin)-1;
sd_k3=2*(k3-kmin)/(kmax-kmin)-1;
sd_k4=2*(k4-kmin)/(kmax-kmin)-1;
sd_k5=2*(k5-kmin)/(kmax-kmin)-1;
sd_k6=2*(k6-kmin)/(kmax-kmin)-1;

sd_a1=2*(a1-amin)/(amax-amin)-1;
sd_a2=2*(a2-amin)/(amax-amin)-1;
sd_a3=2*(a3-amin)/(amax-amin)-1;
sd_a4=2*(a4-amin)/(amax-amin)-1;
sd_a5=2*(a5-amin)/(amax-amin)-1;
sd_a6=2*(a6-amin)/(amax-amin)-1;

Cheby_k1=[1 sd_k1 2*(sd_k1^2)-1];
Cheby_k2=[1 sd_k2 2*(sd_k2^2)-1];
Cheby_k3=[1 sd_k3 2*(sd_k3^2)-1];
Cheby_k4=[1 sd_k4 2*(sd_k4^2)-1];
Cheby_k5=[1 sd_k5 2*(sd_k5^2)-1];
Cheby_k6=[1 sd_k6 2*(sd_k6^2)-1];

Cheby_a1=[1 sd_a1 2*(sd_a1^2)-1];
Cheby_a2=[1 sd_a2 2*(sd_a2^2)-1];
Cheby_a3=[1 sd_a3 2*(sd_a3^2)-1];
Cheby_a4=[1 sd_a4 2*(sd_a4^2)-1];
Cheby_a5=[1 sd_a5 2*(sd_a5^2)-1];
Cheby_a6=[1 sd_a6 2*(sd_a6^2)-1];

% 5) Create complete polynomial matrix 
NoSt=2*N;

X1=Cheby_k1;
X2=Cheby_k2;
X3=Cheby_k3;
X4=Cheby_k4;
X5=Cheby_k5;
X6=Cheby_k6;

X7=Cheby_a1;
X8=Cheby_a2;
X9=Cheby_a3;
X10=Cheby_a4;
X11=Cheby_a5;
X12=Cheby_a6;

REG=zeros(size(X1,1),1+NoSt+(NoSt-1)*NoSt/2+NoSt);
jjj=1;
REG(:,jjj)=ones(size(X1,1),1);
for i=1:NoSt
    jjj=jjj+1;
    XX=eval(['X' num2str(i)]);
    REG(:,jjj)=XX(:,2);
end
for j=1:(NoSt-1)
    for i=(j+1):NoSt
        jjj=jjj+1;
        XXj=eval(['X' num2str(j)]);
        XXi=eval(['X' num2str(i)]);
        REG(:,jjj)=XXj(:,2).*XXi(:,2);
    end
end
for i=1:NoSt
    jjj=jjj+1;
    XX=eval(['X' num2str(i)]);
    REG(:,jjj)=XX(:,3);
end

% 6) Compute decision variables
    
    % Next period's capital stocks
    kp1=REG*dr_k1;
    kp2=REG*dr_k2;
    kp3=REG*dr_k3;
    kp4=REG*dr_k4;
    kp5=REG*dr_k5;
    kp6=REG*dr_k6;
    kp_vec=[kp1;kp2;kp3;kp4;kp5;kp6];
    Kp=kp1+kp2+kp3+kp4+kp5+kp6;
    K=k1+k2+k3+k4+k5+k6;
    
    % Investment
    i1=kp1-(1-delta)*k1;
    i2=kp2-(1-delta)*k2;
    i3=kp3-(1-delta)*k3;
    i4=kp4-(1-delta)*k4;
    i5=kp5-(1-delta)*k5;
    i6=kp6-(1-delta)*k6;
    i_vec=[i1;i2;i3;i4;i5;i6];
    
    % Capital adjustment costs
    cac1=phi/2*k1.*(kp1./k1-1).^2;
    cac2=phi/2*k2.*(kp2./k2-1).^2;
    cac3=phi/2*k3.*(kp3./k3-1).^2;
    cac4=phi/2*k4.*(kp4./k4-1).^2;
    cac5=phi/2*k5.*(kp5./k5-1).^2;
    cac6=phi/2*k6.*(kp6./k6-1).^2;
    CAC=cac1+cac2+cac3+cac4+cac5+cac6;   
    
    % lambda=mu
    mu=exp(REG*dr_mu);
    lambda=mu;
    
    % Scale down mu
    sd_mu=2*(mu-mumin)/(mumax-mumin)-1;
       
    % Create Chebyhsev polynomials of order 8 to compute labor
    ord=8;
    
  	REG_K1=ones(1,ord+1);
    REG_K2=ones(1,ord+1);
    REG_K3=ones(1,ord+1);
    REG_K4=ones(1,ord+1);
    REG_K5=ones(1,ord+1);
    REG_K6=ones(1,ord+1);
    
    REG_A1=ones(1,ord+1);
    REG_A2=ones(1,ord+1);
    REG_A3=ones(1,ord+1);
    REG_A4=ones(1,ord+1);
    REG_A5=ones(1,ord+1);
    REG_A6=ones(1,ord+1);
    
    REG_MU=ones(1,ord+1);
    
    REG_K1(1,2)=sd_k1;
    REG_K2(1,2)=sd_k2;
    REG_K3(1,2)=sd_k3;
    REG_K4(1,2)=sd_k4;
    REG_K5(1,2)=sd_k5;
    REG_K6(1,2)=sd_k6;
    
    REG_A1(1,2)=sd_a1;
    REG_A2(1,2)=sd_a2;
    REG_A3(1,2)=sd_a3;
    REG_A4(1,2)=sd_a4;
    REG_A5(1,2)=sd_a5;
    REG_A6(1,2)=sd_a6;
    
    REG_MU(1,2)=sd_mu;
    
    for i=3:ord+1;
		REG_K1(1,i)=2.*sd_k1.*REG_K1(:,i-1)-REG_K1(:,i-2);
        REG_K2(1,i)=2.*sd_k2.*REG_K2(:,i-1)-REG_K2(:,i-2);
        REG_K3(1,i)=2.*sd_k3.*REG_K3(:,i-1)-REG_K3(:,i-2);
        REG_K4(1,i)=2.*sd_k4.*REG_K4(:,i-1)-REG_K4(:,i-2);
        REG_K5(1,i)=2.*sd_k5.*REG_K5(:,i-1)-REG_K5(:,i-2);
        REG_K6(1,i)=2.*sd_k6.*REG_K6(:,i-1)-REG_K6(:,i-2);
        
        REG_A1(1,i)=2.*sd_a1.*REG_A1(:,i-1)-REG_A1(:,i-2);
        REG_A2(1,i)=2.*sd_a2.*REG_A2(:,i-1)-REG_A2(:,i-2);
        REG_A3(1,i)=2.*sd_a3.*REG_A3(:,i-1)-REG_A3(:,i-2);
        REG_A4(1,i)=2.*sd_a4.*REG_A4(:,i-1)-REG_A4(:,i-2);
        REG_A5(1,i)=2.*sd_a5.*REG_A5(:,i-1)-REG_A5(:,i-2);
        REG_A6(1,i)=2.*sd_a6.*REG_A6(:,i-1)-REG_A6(:,i-2);
        
        REG_MU(1,i)=2.*sd_mu.*REG_MU(:,i-1)-REG_MU(:,i-2);
    end;
    
    counti=0;
    REGMAT1=zeros(size(REG_MU,1),200);
    REGMAT2=zeros(size(REG_MU,1),200);
    REGMAT3=zeros(size(REG_MU,1),200);
    REGMAT4=zeros(size(REG_MU,1),200);
        for i1=0:ord  
            for i2=0:[ord-i1];        
                for i3=0:[ord-i1-i2];
                    counti=counti+1;
                    REGMAT1(:,counti)=REG_MU(:,i1+1).*REG_A1(:,i2+1).*REG_K1(:,i3+1);
                    REGMAT2(:,counti)=REG_MU(:,i1+1).*REG_A2(:,i2+1).*REG_K2(:,i3+1);
                    REGMAT3(:,counti)=REG_MU(:,i1+1).*REG_A3(:,i2+1).*REG_K3(:,i3+1);
                    REGMAT4(:,counti)=REG_MU(:,i1+1).*REG_A4(:,i2+1).*REG_K4(:,i3+1);
                    REGMAT5(:,counti)=REG_MU(:,i1+1).*REG_A5(:,i2+1).*REG_K5(:,i3+1);
                    REGMAT6(:,counti)=REG_MU(:,i1+1).*REG_A6(:,i2+1).*REG_K6(:,i3+1);
                end
            end
        end

    REGMAT1=REGMAT1(:,1:counti);
    REGMAT2=REGMAT2(:,1:counti);
    REGMAT3=REGMAT3(:,1:counti);
    REGMAT4=REGMAT4(:,1:counti);
    REGMAT5=REGMAT5(:,1:counti);
    REGMAT6=REGMAT6(:,1:counti);
    
    l1=REGMAT1*regvec_labor(:,1);
    l2=REGMAT2*regvec_labor(:,2);
    l3=REGMAT3*regvec_labor(:,3);
    l4=REGMAT4*regvec_labor(:,4);
    l5=REGMAT5*regvec_labor(:,5);
    l6=REGMAT6*regvec_labor(:,6);
    l_vec=[l1;l2;l3;l4;l5;l6];
    
    % Consumption
    c1=[[b(1)*(Le-l1).^(-1/chi(1))]./[a1.*(1-alpha).*A.*(l1.^(mupar(1)-1)).*...
        (alpha.*k1.^(mupar(1))+(1-alpha)*l1.^mupar(1)).^(1/mupar(1)-1)]].^(-chi(1));
    c2=[[b(2)*(Le-l2).^(-1/chi(2))]./[a2.*(1-alpha).*A.*(l2.^(mupar(2)-1)).*...
        (alpha.*k2.^(mupar(2))+(1-alpha)*l2.^mupar(2)).^(1/mupar(2)-1)]].^(-chi(2));
    c3=[[b(3)*(Le-l3).^(-1/chi(3))]./[a3.*(1-alpha).*A.*(l3.^(mupar(3)-1)).*...
        (alpha.*k3.^(mupar(3))+(1-alpha)*l3.^mupar(3)).^(1/mupar(3)-1)]].^(-chi(3));
    c4=[[b(4)*(Le-l4).^(-1/chi(4))]./[a4.*(1-alpha).*A.*(l4.^(mupar(4)-1)).*...
        (alpha.*k4.^(mupar(4))+(1-alpha)*l4.^mupar(4)).^(1/mupar(4)-1)]].^(-chi(4));
    c5=[[b(5)*(Le-l5).^(-1/chi(5))]./[a5.*(1-alpha).*A.*(l5.^(mupar(5)-1)).*...
        (alpha.*k5.^(mupar(5))+(1-alpha)*l5.^mupar(5)).^(1/mupar(5)-1)]].^(-chi(5));
    c6=[[b(6)*(Le-l6).^(-1/chi(6))]./[a6.*(1-alpha).*A.*(l6.^(mupar(6)-1)).*...
        (alpha.*k6.^(mupar(6))+(1-alpha)*l6.^mupar(6)).^(1/mupar(6)-1)]].^(-chi(6));
            C=c1+c2+c3+c4+c5+c6;
    c_vec=[c1;c2;c3;c4;c5;c6];
 
% 7) Create output
dv=[c_vec;l_vec;kp_vec;i_vec;lambda];
