/*
 * Copyright (C) 2008-2009 Sébastien Villemot <sebastien.villemot@ens.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <cassert>
#include <iostream>

#include "ModelSolution.hh"

ModelSolution::ModelSolution(const ModelSpec &modspec_arg) throw (UnsupportedSpec)
  : modspec(modspec_arg)
{
}

ModelSolution::~ModelSolution()
{
}

void
ModelSolution::policy_func(const gsl_vector *y_prev, const gsl_vector *shocks, gsl_vector *y_curr)
{
  const int &n = modspec.n;
  assert((int) y_prev->size == 5*n+1 && (int) shocks->size == n+1 && (int) y_curr->size == 5*n+1);
  policy_func_internal(y_prev, shocks, y_curr);
}
