/*
 * Copyright (C) 2009-2010 Sébastien Villemot <sebastien.villemot@ens.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _MRGAL_SOLUTION_HH
#define _MRGAL_SOLUTION_HH

#include <gsl/gsl_matrix.h>

#include "../ModelSolution.hh"

class MRGalSolution : public ModelSolution
{
private:
  const int nr;
  double C_max, C_min, amax, amin, kmax, kmin, mumin, mumax;
  gsl_vector *dr_coeff, *regvec, *REG, *REGC, *REG_MU, *sd;
  gsl_matrix *regvec_labor, *REG_A, *REG_K, *REGMAT;
protected:
  virtual void policy_func_internal(const gsl_vector *y_prev, const gsl_vector *shocks, gsl_vector *y_curr);
public:
  MRGalSolution(const ModelSpec &modspec_arg) throw (UnsupportedSpec);
  virtual ~MRGalSolution();
  virtual std::string name() const;
};

#endif // !_MRGAL_SOLUTION_HH
