/*
 * Copyright (C) 2008 Sébastien Villemot <sebastien.villemot@ens.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _MODEL_SOLUTION_HH
#define _MODEL_SOLUTION_HH

#include <string>

#include <gsl/gsl_vector.h>

#include "ModelSpec.hh"

class ModelSolution
{
protected:
  virtual void policy_func_internal(const gsl_vector *y_prev, const gsl_vector *shocks, gsl_vector *y_curr) = 0;
public:
  class UnsupportedSpec {};
  const ModelSpec &modspec;
  ModelSolution(const ModelSpec &modspec_arg) throw (UnsupportedSpec);
  virtual ~ModelSolution();
  void policy_func(const gsl_vector *y_prev, const gsl_vector *shocks, gsl_vector *y_curr);
  virtual std::string name() const = 0;
};

#endif // !_MODEL_SOLUTION_HH
