/*
 * Copyright (C) 2009-2010 Sébastien Villemot <sebastien.villemot@ens.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _MMJ_SOLUTION_HH
#define _MMJ_SOLUTION_HH

#include <string>

#include <gsl/gsl_matrix.h>
#include <gsl/gsl_spline.h>
#include <gsl/gsl_roots.h>

#include "../ModelSolution.hh"

class MMJSolution : public ModelSolution
{
private:
  // Variables common to all specs
  gsl_matrix *V_prime, *z0_prime;
  int VI_dim1;
  double *VI;
  gsl_vector *meanx, *sigz0, *stdx, *stdz;
  double v;
  int NC;

  // Temporary variables
  gsl_vector *xnorm, *znorm, *crbf, *dist_z_z0, *rbfn, *instrs, *ord2_vec;
  gsl_matrix *z1, *vi, *VI_tmp, *ord2_mat;

  // Specs 1 and 5
  gsl_interp_accel *acc;
  gsl_spline *spline;

  // Specs 2,3,4,6,7,8
  double *VIL;
  int VIL_dim2;
  gsl_matrix *VIL_tmp;
  gsl_matrix *vil;

  struct my_params
  {
    const double *a_curr, *k_prev, *k_curr;
    const ModelSpecA2A6 *modspec;
  };

  std::string matdir;
protected:
  virtual void policy_func_internal(const gsl_vector *y_prev, const gsl_vector *shocks, gsl_vector *y_curr);
public:
  MMJSolution(const ModelSpec &modspec_arg, const std::string &matdir_arg) throw (UnsupportedSpec);
  virtual ~MMJSolution();
  virtual std::string name() const = 0;
};

#endif // !_MMJ_SOLUTION_HH
