/*
 * Copyright (C) 2008-2010 Sébastien Villemot <sebastien.villemot@ens.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _PER_SOLUTION_HH
#define _PER_SOLUTION_HH

#include <gsl/gsl_matrix.h>

#include "../ModelSolution.hh"

class PerSolution : public ModelSolution
{
private:
  //! Compute only a first order approximation
  bool first_order;
  //! Number of control variables
  const int nw;
  //! Number of state variables
  const int nz;
  //! Constant coefficients in Taylor expansion
  gsl_vector *HH0;
  //! First-order coefficients in Taylor expansion
  gsl_matrix *HH1;
  //! Second-order coefficients in Taylor expansion
  gsl_matrix **HH2;
  //! Steady-state for control variables
  gsl_vector *wSS;
  //! Steady-state for state variables
  gsl_vector *zSS;
  //! Temporary variables for policy function computation
  gsl_vector *state, *control, *tmp;
protected:
  virtual void policy_func_internal(const gsl_vector *y_prev, const gsl_vector *shocks, gsl_vector *y_curr);
public:
  PerSolution(const ModelSpec &modspec_arg, bool first_order_arg) throw (UnsupportedSpec);
  virtual ~PerSolution();
  virtual std::string name() const;
};

#endif // !_PER_SOLUTION_HH
