/*
 * Copyright (C) 2008-2010 Sébastien Villemot <sebastien.villemot@ens.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _SMOL_SOLUTION_HH
#define _SMOL_SOLUTION_HH

#include "../ModelSolution.hh"

class SmolSolution : public ModelSolution
{
private:
  //! Number of instances of that class
  static int instances;
  //! Temporary variables for policy function computation
  double *state, *control;
  //! Handle for dynamically opened DLL file
  void *handle;

  void (*paramupdate)();
  void (*incoeffs)(char*);
  void (*test)(double*, double*);
protected:
  virtual void policy_func_internal(const gsl_vector *y_prev, const gsl_vector *shocks, gsl_vector *y_curr);
public:
  SmolSolution(const ModelSpec &modspec_arg) throw (UnsupportedSpec);
  virtual ~SmolSolution();
  virtual std::string name() const;
};

#endif // !_SMOL_SOLUTION_HH
